/*
 *  optab.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "yachead.h"

#include "optab.h"
#include "interp.h"
#include "intfc.h"
#include "cgidbg.h"

static int CheckOperand (ValueType * Op,Operand& Needed)
{
	// LogForm("In CheckOperand Needed.Type = %d", Needed.Type);
	if (Needed.Type != OperandIntEntList) return 0;
		// only operands defined so far
	InteractiveEntity * IntEnt = GetIntEntFromObj(Op);
	if (!IntEnt) return 0;
/*
 *	LogForm("::CheckOperand GetBaseClass = 0x%x, EntityList = 0x%x",
 *		(long) IntEnt->GetBaseClass(), (long) Needed.Op->EntityList);
 */
	int Return = IntEnt->GetBaseClass() == Needed.Op->EntityList ;
	// LogForm("::CheckOperand returning %d", Return);
	return Return ;
}

	

BinarySemanticRoutine OperandAndSemant::CheckOperand(ValueType* Opnd2)
{
	if (::CheckOperand(Opnd2,Op2)) {
/*
 *		LogForm("OperandAndSemant::CheckOperand returning BinOp = 0x%x",
 *			(long) BinOp);
 */
		return BinOp;
	}
	// LogMsg("OperandAndSemant::CheckOperand returning 0");
	return 0;
}

BinarySemanticRoutine OperandOpt::CheckOperands(ValueType* Opnd1,
	ValueType* Opnd2)
{
	// LogMsg("BinarySemanticRoutine");
	if (!CheckOperand(Opnd1,Op1)) return 0;
	// LogMsg("BinarySemanticRoutine starting loop");
	for (OperandAndSemant *Ptr = Op2 ; Ptr->Op2.Type != OperandEnd; Ptr++) {
		BinarySemanticRoutine Routine = Ptr->CheckOperand(Opnd2);
		if (Routine) {
/*
 *			LogForm("OperandOpt::CheckOperands returning 0x%x",
 *				(long) Routine );
 */
			return Routine ;
		}
	}
	// LogMsg("OperandOpt::CheckOperands returning 0");
	return 0;
}

void ClassOp::Dump()
{
	TheLog << "ClassOp::Dump - Operator = " << Operator << ", Operands = 0x"
		<< hex << (long) Operands << dec << "\n" ;
	for (OperandOpt * Ptr = Operands; Ptr->Op1.Type != OperandEnd;Ptr++)
		Ptr->Dump();
}

void OperandOpt::Dump()
{
	TheLog << "OperandOpt::Dump - Operand. is:\n";
	Op1.Dump();
	TheLog << "OperandOpt::Dump - Op2-> is:\n";
	Op2->Dump();
}


void Operand::Dump()
{
	TheLog << "Operand::Dump - Type = " << Type << ", List = 0x" << hex
		<< (long) Op->EntityList << dec << "\n" ;
}


void OperandAndSemant::Dump()
{
	TheLog << "OpearndAndSemant::Dump - Op2. is:\n";
	Op2.Dump();
	TheLog << "OpearndAndSemant::Dump - BinOp. = 0x" << hex << (long) BinOp
		<< dec << "\n" ;
}




