/*
 *  noderep.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "noderep.h"
#include "network.h"
#include "dfnode.h"
#include "cgidbg.h"
#include "yacintfc.h"

// void TestAlloc(const char * msg=0);


const char * const NodeReplacement::validate_compare_replace =
	"ValCmpRep" ;
const char * const NodeReplacement::validate_output_replace =
	"ValeOutRep" ;

// The node replacement node is generally a temproary node that should
// be deleted on exit because the network is restored to its original sate.

NodeReplacement::~NodeReplacement()
{
/*
 *	if (replacement_node) LogOut << "NodeReplacement::dtor about to delete:\n`" <<
 *  		replacement_node->GetName() << "'.\n" ;
 */
 
	delete replacement_node ;
	replacement_node = 0 ;
}

void NodeReplacement::dump()
{
	TheLog << " c at " << (void *) current_node << ", r at " <<
		(void *) replacement_node << "\n" ;
	TheLog << "c = `" <<
		( current_node ?  current_node->GetName() : "NULL NODE" ) << "', r = `"
		<< ( replacement_node ?  replacement_node->GetName() : "NULL NODE" )
		<< "'.\n" ;
}

void NodeReplacement::replace(ProcessNet& net)
{
	net.ReplaceNode(*current_node,*replacement_node);
}

void NodeReplacement::relay(NodeReplacementList& nodes_to_replace)
{
	NodeReplacementListIterator Next(nodes_to_replace);
    NodeReplacement * rep ;
    while  (rep = Next()) if (replacement_node == rep->current_node) {
		rep->current_node = 0 ;
		delete replacement_node ;
		replacement_node = rep->replacement_node ;
		rep->replacement_node = 0 ;
		break ;
	}

	if (!rep) State.Error("cannot find replacement for `",
		replacement_node->GetName(), "'");
}

void NodeReplacement::restore(ProcessNet& net)
{
	// LogOut << "NodeReplacement::restore\n" ;
	net.ReplaceNode(*replacement_node,*current_node);
	// LogOut << "NodeReplacement::restore exit\n" ;
}

NodeReplacementList::~NodeReplacementList()
{
	NodeReplacement * rep ;
	while (rep = Get()) {
		if (the_no_delete_flag) rep->no_delete();
		// LogOut << "no_delete_flag = " << the_no_delete_flag << "\n" ;
		// LogOut << (void *) rep << "\n" ;
		delete rep ;
	}
}

void NodeReplacementList::dump()
{
	TheLog << "NodeReplacementList::dump for `" << the_net.GetName() <<
		"', target = `" << the_target_name << "', no_del = " <<
		the_no_delete_flag << "\n" ;
	NodeReplacementListIterator Next(*this);
    NodeReplacement * rep ;
    while  (rep = Next()) {
		TheLog << (void *) rep << "\n" ;
		rep->dump();
	}
}

void NodeReplacementList::relay(NodeReplacementList& nodes_to_replace)
{
	NodeReplacementListIterator Next(*this);
    NodeReplacement * rep ;
    while  (rep = Next()) rep->relay(nodes_to_replace);
}

void NodeReplacementList::replace()
{
	NodeReplacementListIterator Next(*this);
	NodeReplacement * rep ;
	while  (rep = Next()) rep->replace(the_net);
}

void NodeReplacementList::restore()
{
	NodeReplacementListIterator Next(*this);
	NodeReplacement * rep ;
	while  (rep = Next()) rep->restore(the_net);
}

