/*
 *  adjust.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "portable.h"

class TraverseObject ;
class DfNodeInLink ;

class Adjustment {
	TraverseObject& Object ;
	int32 EnlargeBase ;  // Factor for new multiple of sequence length
	int EnlargeSize ;
	int NewTotal ;
	int SequenceIndex ;
	DfNodeInLink * PathIn ;
public:
	enum Command {EnlargeSequence,EnlargeBuffer,EnlargeMultiplier,
		SetFlushSize}
		TheCommand ;
	Adjustment(Adjustment& obj);
	Adjustment(TraverseObject& obj, Command cmd, int32 Enlarge_Base,
		int Enlarge_Size=0, int New_Total= 0, int Sequence_Index=0);
	Command GetCommand() const {return TheCommand;}
	int GetEnlargeBase() const {return EnlargeBase;}
	int GetEnlargeSize() const {return EnlargeSize;}
	int GetNewTotal() const {return NewTotal;}
	int GetSequenceIndex() const {return SequenceIndex;}
	void ChangeBase(int NewBase) {EnlargeBase = NewBase;}
	TraverseObject& GetTraverseObject() const {return Object;}
	DfNodeInLink * GetInLink() const {return PathIn;}
	void SetInLink(DfNodeInLink * Path_In) {PathIn = Path_In;}
};

