/*
 *  blckwrt.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "blckwrt.h"
#include "netlnk.h"
#include "cgidbg.h"
#include "tarnod.h"

ReadWriteBlock::ReadWriteBlock(TargetNode& node, int cx_in, int cx_out):
	ReadWriteSingleChannel(node, cx_in, cx_out),
	ReadPtrB(0),
	WritePtrB(0)
{

	if (TheNode.GetIn() == 2) {
		if (ComplexIn) DebugCodeError(13,"ReadWriteBlock::Ctor","bad input",0);
		ReadBaseB = TheNode.GetReadBase(1) ;
		ReadEndB = TheNode.GetReadEnd(1) ;
	} else {
		ReadBaseB = 0 ;
		ReadEndB = 0 ;
	}


	if (TheNode.GetOut() == 2) {
		if (ComplexOut) DebugCodeError(14,"ReadWriteBlock::Ctor","bad output",0);
		WriteBaseB = TheNode.GetWriteBase(1) ;
		WriteEndB = TheNode.GetWriteEnd(1) ;
	} else {
		WriteBaseB = 0 ;
		WriteEndB = 0 ;
	}
}

void ReadWriteBlock::InitPtr()
{
	ReadWriteSingleChannel::InitPtr();
	InitPtr();
}

void ReadWriteBlock::InitPtrBase()
{
	if (TheNode.GetIn() == 2) ReadPtrB = TheNode.GetReadPtr(1); 
	if (TheNode.GetOut() ==2) WritePtrB = TheNode.GetWritePtr(1) ;
}



int32 ReadWriteBlock::GetCount(int32 MaxCount)
{
	InitPtrBase();
	int32 CountToExecute = ReadWriteSingleChannel::GetCount(MaxCount);
	if (TheNode.GetOut() ==2) {
		int32 CountOut = TheNode.GetContiguousSpace(1) ;
		if (CountToExecute > CountOut) CountToExecute = CountOut ;
	}

	if (TheNode.GetIn() == 2) {
		int32 CountOut = TheNode.GetContiguousAvailableData(1) ;
		if (CountToExecute > CountOut) CountToExecute = CountOut ;
	}
	return CountToExecute ;
}


int32 ReadWriteBlock::Update(int32 CountToExecute)
{
	ReadWriteSingleChannel::Update(CountToExecute);
	if (TheNode.GetIn() == 2) TheNode.UpdateRead(CountToExecute,1);
	if (TheNode.GetOut() == 2) TheNode.UpdateWrite(CountToExecute,1);
	return CountToExecute ;
}

ReadWriteSingleChannel::ReadWriteSingleChannel(
	TargetNode& node, int cx_in, int cx_out):
	TheNode(node),
	ReadBase(node.GetReadBase()),
	ReadEnd(node.GetReadEnd()),
	WriteBase(node.GetWriteBase()),
	WriteEnd(node.GetWriteEnd()),
	ReadPtr(0),
	WritePtr(0),
	ComplexIn(cx_in),
	ComplexOut(cx_out)
{
}

void ReadWriteSingleChannel::InitPtr()
{
	ReadPtr = TheNode.GetReadPtr(); 
	WritePtr = TheNode.GetWritePtr() ;
}

int32 ReadWriteSingleChannel::GetCount(int32 MaxCount)
{
	InitPtr();
	int32 CountToExecute = MaxCount ;

	int32 CountOut = TheNode.GetContiguousSpace() ;
	if (ComplexOut) CountOut >>= 1;
	if (CountToExecute> CountOut) CountToExecute = CountOut ;

	CountOut = TheNode.GetContiguousAvailableData(0) ;
	if (ComplexIn) CountOut >>=1 ;
	if (CountToExecute > CountOut) CountToExecute = CountOut ;

	return CountToExecute ;
}

int32 ReadWriteSingleChannel::Update(int32 CountToExecute)
{
	int32 ReadUpdate = CountToExecute ;
	if (ComplexIn) ReadUpdate <<= 1 ;
	TheNode.UpdateRead(ReadUpdate);

	int32 WriteUpdate = CountToExecute ;
	if (ComplexOut) WriteUpdate <<= 1 ;
	TheNode.UpdateWrite(WriteUpdate);

	return CountToExecute ;
}

void ReadWriteSingleChannel::ReadBlock(int32 TooMove, MachWord * InputBuffer)
{
	while (TooMove) {
		ReadPtr = TheNode.GetReadPtr();
		int32 Count = TheNode.GetContiguousAvailableData();
		if (Count > TooMove) Count = TooMove ;
		const MachWord * Limit = ReadPtr + Count ;
		while(ReadPtr < Limit) *InputBuffer++ = *ReadPtr++ ;
		TooMove -= Count ;
		TheNode.UpdateRead(Count);
	}
}

void ReadWriteSingleChannel::WriteBlock(int32 TooMove,
	const MachWord * OutputBuffer)
{
	while (TooMove) {
		WritePtr = TheNode.GetWritePtr();
		int32 Count = TheNode.GetContiguousSpace();
		if (Count > TooMove) Count = TooMove ;
		const MachWord * Limit = WritePtr + Count ;
		while(WritePtr < Limit) *WritePtr++ = *OutputBuffer++  ;
		TooMove -= Count ;
		TheNode.UpdateWrite(Count);
	}
}

void ReadWriteSingleChannel::WriteBinaryBlock(int32 TooMove,
	const BinMachWord * OutputBuffer)
{
	BinMachWord * BinWritePtr ;
	while (TooMove) {
		BinWritePtr = (BinMachWord *) TheNode.GetWritePtr();
		int32 Count = TheNode.GetContiguousSpace();
		if (Count > TooMove) Count = TooMove ;
		const BinMachWord * Limit = BinWritePtr + Count ;
		while(BinWritePtr < Limit) *BinWritePtr++ = *OutputBuffer++  ;
		TooMove -= Count ;
		TheNode.UpdateWrite(Count);
	}
	WritePtr = (MachWord *) BinWritePtr ;
}

MachWord * ReadWriteSingleChannel::GetInputBuffer()
{
	int32 size = ReadEnd-ReadBase ;
	return (MachWord *) new MachWordCast[size] ;
}

MachWord * ReadWriteSingleChannel::GetOutputBuffer()
{
	int32 size = WriteEnd-WriteBase ;
	return (MachWord *) new MachWordCast[size] ;
}

