/*
 *  blockc.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProGui/yacintfc.h"
#include "ObjProUsr/block.h"
#include "ObjProComGui/cgidbg.h"

void Block::ctor()
{
}

ErrCode Block::kernel(int32 k)
{
	int32 i,b,e;
	// TheLog << "Limit = " << Limit << "\n" ;
	switch (the_convert_type) {
default:
 	   State.Error("unsupported arithmetic conversion");
    	return FatalError;
case undefined:
		State.Error("`", GetName(), "' not initialized");
		return FatalError ;
case no_conversion:
		for (i = 0 ; i <k ; i++ )
		for (b = 0 ; b < TargetNode::GetBlockSize(); b++) 
		for (e = 0; e < TargetNode::GetEltSize(); e++)
					WriteBinary(ReadBinary()) ;
		return OK ;
case float_to_int:
		for (i = 0 ; i <k ; i++ )
		for (b = 0 ; b < TargetNode::GetBlockSize(); b++) 
		for (e = 0; e < TargetNode::GetEltSize(); e++) {
			float test = ReadWord();
			int warn=0 ;
			if (test > MachWord::max_int_positive) test =
				MachWord::max_int_positive,warn=1;
			else if (test < MachWord::min_int_negative) test = 
				MachWord::min_int_negative,warn=1;
			if (warn) MachWord::hard_limit_warn();
			WriteInteger((int32)test) ;
		}
		return OK ;
case int_to_float:
		for (i = 0 ; i <k ; i++ )
		for (b = 0 ; b < TargetNode::GetBlockSize(); b++) 
		for (e = 0; e < TargetNode::GetEltSize(); e++)
			WriteWord((ReadBinary())) ;
		return OK ;
	}
}

