/*
 *  firc.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "gcd.h"
#include "firc.h"

int DeltaIn(int16 Resample, int16 ZeroPad)
{
	if (!ZeroPad) return Resample ;
	return Resample / GreatestCommonDivisor(Resample,(ZeroPad+1));
}


int DeltaOut(int16 Resample,int16 ZeroPad)
{
	if (!ZeroPad) return 1 ;
	return (ZeroPad+1) / GreatestCommonDivisor(Resample,(ZeroPad+1));
}

