/*
 *  readint.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <fcntl.h>
#include <libc.h>
#include <ctype.h>
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/sysconst.h"
#include "ObjProGui/yacintfc.h"
#include "ObjProGen/mkstr.h"
#include "ObjProGen/environ.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/readint.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * ReadIntNodeList = 0 ;
static InteractiveEntity * IntEntReadInt ;
void ReadIntNodesInit();
ReadInt::ReadInt (const char * Name, const char * FileName, int16 Flags):
	Signal(Name, 1, 1, 1, 1, TimingTypeLinear, 
	(ArithType::ArithCapabilities)(((Flags & 2) && TheArithType == ArithType::ArithFloat) ? ArithType::ArithInt32 : TheArithType))
,
	FileName_1(FileName),
	Flags_2(Flags)
{
	if (!ReadIntNodeList) ReadIntNodesInit() ;
	ReadIntNodeList->Append(MakeDeclaredEntity(this, IntEntReadInt)) ;
	InitArithType(TheArithType);
	NewMenuItem("ReadInt",GetName());
#line 58 "../readint.usr"
 
	ReadIntFile = 0 ;
	exp_name = 0 ;
	delete_name = 0 ;
	DidCheck = 0 ;
	open_f(0);
#line 54 "../readint.C"
} // end constructor

ReadInt::~ReadInt()
{
	TheMenuServer->DeleteMenuItem("ReadInt",GetName());
	ReadIntNodeList->Delete(GetName()) ;
#line 66 "../readint.usr"
 
	delete ReadIntFile ;
	delete delete_name ;
	delete exp_name ;
#line 66 "../readint.C"
} // end destructor

int ReadInt::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

ReadInt * ReadIntDef;

ErrCode ReadInt::DoNode(int32 k)
{
#line 89 "../readint.usr"
 
	return kernel(k);
#line 83 "../readint.C"
} // end kernel code

static UserEntity * MakeReadInt(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int ReadInt::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntReadInt->CppList(Out,Cmd,this);
}

void ReadInt::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakeReadInt(Out,EntityReqDescribeFull,*IntEntReadInt,TheArithType);
		Out.NewLine();
		Out.NextQuoteOut("FileName");
		Out.NextQuoteOut(GetFileName());
		Out.NextFillOut("specifies the the disk file");
		Out.NextFillOut("to be read. If no name is specified the node name will be used.");
		Out.NextQuoteOut("Flags");
		Out.NextFillOut("(");
		Out.NextFillOut(TypeToString(GetFlags()));
		Out.NextFillOut(")");
		Out.NextFillOutConcat("&1 specifies hex format file with optional");
		Out.NextFillOut("0x or 0X prefix for each value.");
		Out.NextQuoteOut("Flags");
		Out.NextFillOutConcat("&2 will write");
		Out.NextFillOut("32 bit integer data on a floating point simulator.");
		Out.NextFillOut("Decimal format files are read as signed integers and");
		Out.NextFillOut("hexadecimal format as unsigned.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntReadInt->GetOneParameter("FileName")->
			StringP->CurrentValue = FileName_1;
		IntEntReadInt->GetOneParameter("Flags")->
			IntP->CurrentValue = Flags_2;
		break;
	}
} // end  list entity switch

void ReadIntNodesInit()
{
	if (ReadIntNodeList)  return ;

	static StringParam ReadIntNameParam =
		{"ReadInt", MakeNewEntityName, 0, LegalEntityName};
	static StringParam ReadIntFileNameParam = {
		 0, 0, 0};
	static IntParam ReadIntFlagsParam = {
		 0, 0,  0,  0,  0,  3};

	static OneParameter ReadIntParArray[] = {
		{"Name", 0, "node name", 0, 0, &ReadIntNameParam},
		{"FileName", 0, 
			"ascii file to read",
			0, 0, &ReadIntFileNameParam},
		{"Flags", 0, 
			"flag for hex format input (1) and signed integer output (2)",
			&ReadIntFlagsParam, 0, 0, 0, 0, 1},
		{0}
	};

	ReadIntNodeList = new EntityList;
	IntEntReadInt = new InteractiveEntity("ReadInt", ReadIntNodeList,
		MakeReadInt, InteractiveNode, "readint.h",
		0, "Signal");
	IntEntReadInt->SetParameters(new UserParameters(ReadIntParArray));
	TheNodes->Append(IntEntReadInt);
} // end initalization

static UserEntity * MakeReadInt(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("ReadInt");
		Out.NextFillOut("read a file containing ascii formatted integers and");
		Out.NextFillOut("writes the values to a");
		Out.NextFillOut("`MachWord'");
		Out.NextFillOut("data stream. If");
		Out.NextQuoteOut("Flags");
		Out.NextFillOutConcat("&2 is");
		Out.NextFillOut("set on a 32 bit simulator 32 bit integer values will be written.");
		Out.NextFillOut("You can have as many values is you want on each line but there");
		Out.NextFillOut("can only be white space as defined in the");
		Out.NextFillOut("C++ input stream functions between numbers.");
		Out.NextFillOut("`ImportData'");
		Out.NextFillOut("can");
		Out.NextFillOut("process more complex input files.");
		Out.NextFillOut("If");
		Out.NextQuoteOut("Flags");
		Out.NextFillOutConcat("&1 is set a hexadecimal input will be read as");
		Out.NextFillOut("unsigned integers and converted as needed.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * FileName =
			IntNode.GetStringParameterValue("FileName");
		int16 Flags =
			IntNode.GetIntParameterValue("Flags");
		return new ReadInt(Name, FileName, Flags);

	}
	}
	return 0;
}

static InitObj LocalInit(ReadIntNodesInit, "ReadInt", "Signal");

