/*
 *  axslab.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef AXSLAB_DOT_H
#define AXSLAB_DOT_H
typedef const char * (*AxisLabelString)(double value) ;

class Graph ;

class AxisLabelBase {
	int MaxNoCharacters ; // max character in label entry for in tick
	double FirstTick ;
	double SizeInTicks ;
	AxisLabelString GetTickLabel ;
	Graph * ThePlotWindow ;
public:
	void Init();
	AxisLabelBase(Graph * Win) ;
	const char * GetNextLabel(int InitFlag) ; // 0 for initialize
	int GetMaxNoCharacters() {return MaxNoCharacters;}
	double GetFirstTick() {return FirstTick;}
	double GetSizeInTicks() {return SizeInTicks;}
	void SetPlotWindow (Graph * Win) {ThePlotWindow=Win;}
	void Check();
	// class Screen * GetScreen() ;
	virtual void SetTickSpacing() {}
	class DataPlot * GetDataPlot() ;
 	class DataPlotHeader * GetDataPlotHeader() ;
	Graph * GetPlotWindow() {return ThePlotWindow;}
	void SetTickParms(double first, double size) 
		{FirstTick =first; SizeInTicks = size;}
	void SetMaxNoCharacters(int Max) {MaxNoCharacters = Max;}
	void WriteLabelText( const char * Text, int32 X, int32 Y) ;
} ;

class AxisLabelX: public AxisLabelBase {
public:
	void Init();
	AxisLabelX(Graph * Win):AxisLabelBase(Win){Init();}
	virtual void SetTickSpacing() {}
/*
 *	AxisLabelX(int ch, double first, double inc, AxisLabelString getlab)
 *		{MaxNoCharacters = ch; FirstTick = first ;
 *			SizeInTicks = inc ; GetTickLabel = getlab;}
 */
	virtual void WriteLabel(int Ix, int32 x) ;
} ;

class AxisLabelY: public AxisLabelBase {
public:
	void Init();
	AxisLabelY(Graph * Win):AxisLabelBase(Win){Init();}
	virtual void SetTickSpacing() {}
/*
 *	AxisLabelY(int ch, double first, double inc, AxisLabelString getlab)
 *		{MaxNoCharacters = ch; FirstTick = first ;
 *			SizeInTicks = inc ; GetTickLabel = getlab;}
 */

	virtual void WriteLabel(int Ix, int32 y) ;
} ;

	

class AxisLabelingLinearY: public AxisLabelY {
	void Init();
public:
	AxisLabelingLinearY(Graph * Win):AxisLabelY(Win){Init();}
	virtual void SetTickSpacing() ;
	virtual void WriteLabel(int Ix, int32 y) ;
} ;

class AxisLabelingLogarithmicY: public AxisLabelY {
public:
	AxisLabelingLogarithmicY(Graph * Win):AxisLabelY(Win){}
	virtual void SetTickSpacing() ;
} ;

class AxisLabelingLinearX: public AxisLabelX {
	void Init();
public:
	AxisLabelingLinearX(Graph * Win):AxisLabelX(Win){Init();}
	double GetSampleRate() ;
	virtual void SetTickSpacing() ;
	virtual void WriteLabel(int Ix, int32 x) ;
	double GetDynamicSampleRateFactor() ;
} ;

class AxisLabelingLogarithmicX: public AxisLabelX {
public:
	AxisLabelingLogarithmicX(Graph * Win):AxisLabelX(Win){}
	virtual void SetTickSpacing() ;
} ;


#endif /* #ifdef AXSLAB_DOT_H */
