/*
 *  pack.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
// Routine to pack and unpack arbitrary data structures for
// transmission remotely

#include <string.h>
#include "shared.h"
#include "remcom.h"
#include "pack.h"

void PackAndSend::SendPacket()
{
	Head.DataSize = NextByte+1;
	WriteSeg->WritePacket(Head,Buf);
	NextByte=0;
}


void PackAndSend::AddBytes(char * Pt, int N)
{
	for (int i = 0 ; i < N ; i++) {
		if (NextByte >= MaxPacketSize) SendPacket();
		Buf[NextByte++] = *Pt++;
	}
}


void PackAndSend::AddItem(PackDesc& Desc, const void * Item)
{
	int N = Desc.NumItems ;
	if (!N) return ;
	int B = Desc.NumBytes ;
	if (N == -1) N = 1 ;
	if (B) AddBytes((char *)Item,B*N);
	else  {
		char ** Data = (char **) Item ;
		for (int i = 0 ; i < N ; i++)
			AddBytes(Data[i],strlen(Data[i])+1);
	}
}

	
