/*
 *  dosname.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <ctype.h>
#include <string.h>
#include "dosname.h"
#include "mkstr.h"

// convert directory name to legal dos name
// 1. convert to lower case
// 2. truncate to 8 characters
// convert all characters except except `!', `%', -', `@', `{' and `}'

char * ToDosName(const char * UnixName, int CppNameFlag)
{
	// 1. remove directory part of name, out it back when done
	const char * orig_name = UnixName ;
	char * to_delete = RemoveDirectory(UnixName);
	UnixName = to_delete ;

	// LogOut << "ToDosName(" << UnixName << ", " << CppNameFlag << ")\n" ;
	const MaxDosPrefix = 8 ;
	const MaxDosSuffix = 3 ;
	const char * UnixDosChar = "!%-@{}" ;
	const MaxDosName = MaxDosPrefix + 1 + MaxDosSuffix ;
	char NameBuf[MaxDosName+1];
	for (const char * FirstDot = UnixName; *FirstDot && *FirstDot != '.';
		FirstDot++);
/*
 *	LogOut << "*FirstDot = `" << *FirstDot << "', FirstDot = " <<
 *		(void *) FirstDot << ", UnixName = " << (void *) UnixName <<
 *		", df = " << (FirstDot - UnixName) << "\n" ;
 */
	strncpy(NameBuf,UnixName,MaxDosName);
	if (*FirstDot) {
		int Length = FirstDot - UnixName  ;
		if (Length > MaxDosPrefix) Length = MaxDosPrefix ;
		strncpy(NameBuf+Length,FirstDot,MaxDosSuffix+1);
		NameBuf[Length + MaxDosSuffix + 1] = '\0' ;
	} else NameBuf[MaxDosPrefix] = '\0' ;
	// LogOut << "ToDosName before char trans `" << NameBuf << "'\n" ;
	const char * ReadDot = 0 ;
	for (char * Ptr = NameBuf ; *Ptr; Ptr++) {
		char P = *Ptr ;
		if (!isascii(P)) {
			*Ptr = '@' ;
			continue ;
		}
		if (isalnum(P)) {
			if (CppNameFlag) if (ReadDot == Ptr - 1)
				if (P == 'C') continue ;
			*Ptr = tolower(P);
			continue ;
		}
		if (P == '_') continue ;
		if (P == '.') if (!ReadDot) {
			ReadDot = Ptr ;
			continue ;
		}
		for (const char * Legal = UnixDosChar; *Legal ; Legal++)
			if (P == *Legal) break ;
		if (*Legal) continue ; 
		*Ptr = '@' ;
	}
	// LogOut << "ToDosName returning `" << NameBuf << "'\n" ;
	char * dir = FindDirectory(orig_name);
	delete to_delete ;
	if (dir) {
		char * Return = Concatenate(dir,"/",NameBuf);
		delete dir ;
		return Return ;
	}
	return Concatenate(NameBuf);
}

char * ToCppName(const char * String)
{
	if (!String) return 0 ;
	if (!*String) return 0 ;
	char * Return = Concatenate(String);
	if (!isalpha(*Return)) *Return = '_' ;
	for (char * Ptr = Return; *Ptr ; Ptr++)
		if (!isascii(*Ptr)) *Ptr = '_' ;
		else if (isalnum(*Ptr)) continue ;
		else *Ptr = '_' ;
	return Return ;
}

char * TruncateToLength(char * Name, int Length)
{
	int Len = strlen(Name);
	for (int i = Len ; i > Length; i--) Name[i-1] = '\0' ;
	return Name ;
}

char * TruncateToDosPrefix(char * Name,int SaveLast)
{
	char * Save = 0 ;
	int Length = strlen(Name);
	if (SaveLast > Length) SaveLast = Length ;
	char * SavePos = Name + Length - SaveLast ;
	if (SaveLast) Save = Concatenate(SavePos);
	cerr << "Save = `" << Save << "'\n" ;
	if (SaveLast > MaxDosPrefix) SaveLast = MaxDosPrefix ;
	cerr << "Name `" << Name << "', SaveLast = " << SaveLast << "\n" ;
	TruncateToLength(Name,MaxDosPrefix - SaveLast) ;
	cerr << "Name `" << Name << "', MaxDosPrefix = " << MaxDosPrefix <<"\n";
	if (Save) strcpy(SavePos,Save);
	delete Save ;
	cerr << "Returning `" << Name << "'\n" ;
	return Name ;
}


