/*
 *  cgisig.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdlib.h>
#include "sysintfc.h"
#include "shared.h"
#include "cgidbg.h"
#include "syssig.h"
#include "ques.h"
#include "cgisig.h"
// #include "guimouse.h"

extern "C" int __std_filebuf_2;
int __std_filebuf_2;

extern void linux_core_dump();

static void SigHandle(int Signal)
{
	static int CleanUpAttempted = 0 ;
	TheLog << "Signal " << Signal << " caught, forcing core dump.\n";
#ifdef __linux__
	linux_core_dump();
#else
	kill(getpid(),SIGQUIT);
#endif
	ExitOneWayOrAnother();
}


void SetCgiSignals()
{
	SetCatchSignals(SigHandle);
}

