/*
 *  dynmen.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DYNMEN_DOT_H
#define DYNMEN_DOT_H
#include "menu.h"

class DynamicMenu: public Menu {
	int MenuItemSlotsAvailable ;
	int StaticItemSlots ;
	MenuExtension * TheItems ;
	void MakeMoreSlots(MenuLine * Addition=0) ;
public:
	DynamicMenu(const char * Head, MenuLine * Items,int MulUse = 0,
		CommandParameters * init = 0) ;
	~DynamicMenu();
	void AddItem(MenuLine * NewLine);
	void DeleteItem(const char * Command);
};

class DynamicMenuControl {
	class DynamicMenuList * TheDynamicMenus ;
public:
	DynamicMenuControl() ;
	~DynamicMenuControl();
	DynamicMenu * CheckMenu(DynamicMenu * TheMenu) ;
	void AddMenu(DynamicMenu *);
	void AddMenuItem(DynamicMenu * menu, MenuLine * Line);
	void DeleteMenuItem(DynamicMenu * menu, const char * Command);
} ;

extern DynamicMenuControl * TheDynamicMenuController ;

#endif /* #ifdef DYNMEN_DOT_H */
