/*
 *  wfiles.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "portable.h"
#include "plotdatg.h"

class PlotChannelPointer ;
class DataPlot ;

class DataFile {
protected:
	const char * Name ;
	int TheFile;
	long NextByteToRead ;
	long NextByteToWrite ;
	void SeekEnd() ;
public:
	DataFile() ;
	virtual ~DataFile() ;
	virtual int Read(int Size, char * Data, long Where = -1) ;
	virtual void WriteData(int Size, const char * Data) ;
	virtual long GetNextByteToWrite(){return NextByteToWrite;}
	virtual long GetNextByteToRead(){return NextByteToRead;}
	virtual void Seek(long Where) ;
	const char * GetName() const {return Name;}
} ;

class DataFileClone: public DataFile {
	int word_factor ;
	int sample_factor ;
	void update_from_clone(long where);
	PlotChannelPointer& base_channel ;
	DataPlot& base_plot ;
	DataFile& base_file ;
	PlotChannelPointer& this_channel ;
	DataPlot::Transform the_transform ;
public:
    DataFileClone(PlotChannelPointer * base, DataPlot::Transform transform,
		PlotChannelPointer* from);
    virtual ~DataFileClone() ;
    virtual int Read(int Size, char * Data, long Where = -1) ;
    virtual void WriteData(int Size, const char * Data) ;
    virtual long GetNextByteToWrite();
    virtual long GetNextByteToRead();
    virtual void Seek(long Where) ;
	int convert_write(int Size, const double *Data);
	int get_word_factor() const {return word_factor;}
};

struct ChangedLines{
	long Address;
	int32 Line;
} ;

