/*
 *  bound_val.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "bound_val.h"
#include <InterViews/background.h>
#include <InterViews/layout.h>
#include <InterViews/label.h>
#include <InterViews/glyph.h>
#include <IV-look/kit.h>
#include <InterViews/style.h>
#include <InterViews/font.h>
#include <InterViews/event.h>
#include <X11/keysym.h>
#include <unistd.h>
#include "cgidbg.h"
#include "dsp_app.h"

#include <InterViews/adjust.h>
#include <InterViews/session.h>
#include <InterViews/window.h>
#include <OS/string.h>
#include <iostream.h>

BoundedValue::BoundedValue()
{
    lower_ = 0.0 ;
    span_ = 0.0 ;
    scroll_incr_ = 1. ;
    page_incr_ = 1. ;
    curvalue_ = 0.0 ;
	window_size_ = 0;
}

BoundedValue::~BoundedValue() { }

void BoundedValue::lower_bound(Coord c) { lower_ = c; }
void BoundedValue::upper_bound(Coord c) { span_ = c - lower_; }

void BoundedValue::current_value(Coord value) {
	// if (value == curvalue_) return ;
    curvalue_ = value;
    constrain(Dimension_X, curvalue_);
    notify(Dimension_X);
    notify(Dimension_Y);
}

void BoundedValue::scroll_incr(Coord c) { scroll_incr_ = c; }
void BoundedValue::page_incr(Coord c) { page_incr_ = c; }

#define access_function(name,value) \
Coord BoundedValue::name(DimensionName) const { \
    return value; \
}

void BoundedValue::window_size(Coord s) {window_size_=s;}

access_function(lower,lower_)
access_function(upper,lower_ + span_)
access_function(length,span_)
access_function(cur_lower,curvalue_)
access_function(cur_upper,curvalue_ + window_size_)
access_function(cur_length,window_size_)

void BoundedValue::scroll_to(DimensionName d, Coord position) {
    Coord p = position;
    constrain(d, p);
    if (p != curvalue_) {
	curvalue_ = p;
	notify(Dimension_X);
	notify(Dimension_Y);
    }
}


#define scroll_function(name,expr,string_name) \
void BoundedValue::name(DimensionName d) { \
   /* \
	*  LogOut << "FieldValue::" << string_name << "()\n" ; */ \
    scroll_to(d, curvalue_ + expr); \
}

scroll_function(scroll_forward,+scroll_incr_,"scroll_forward")
scroll_function(scroll_backward,-scroll_incr_,"scroll_backward")
scroll_function(page_forward,+page_incr_,"page_forward")
scroll_function(page_backward,-page_incr_,"page_backward")


