/*
 *  textdefs.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "textdefs.h"
#include "dsp_app.h"
#include "cgidbg.h"

static CaptureRead capture;

static void capture_read(const char * str, InputType  type, void * obj)
{
	capture.read(str,type,obj);
}

CaptureRead& CaptureRead::capture_read()
{
	return ::capture ;
}

SuspendedRead CaptureRead::capture(SuspendedRead rd)
{
	return ::capture.do_capture(rd);
}

SuspendedRead CaptureRead::do_capture(SuspendedRead rd)
{
	if (rd == (SuspendedRead) capture_read) return rd ;
	set_suspend(rd);
	return ::capture_read ;
}

void CaptureRead::read(const char * str, InputType type, void * obj)
{
	DspApplication::record_prompt(str);
	to_call(str,type,obj);
}
