/*
 *  arthtyp.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef ARTHTYP_DOT_H
#define ARTHTYP_DOT_H

/*
 *	IMPORTANT 		IMPORTANT 		IMPORTANT 	
 *
 * Must update help file `ionod.roff if information in this header is changed
 *
 */ 


#ifndef TI_C30
// the following values are hard coded in `datafile.h' for the TI_C30
// start ArithType definition (this line used in generating manual)
// Dummy class to limit name space polution
class ArithType {
public:
	enum ArithTypes {ArithTypeUndefined=0,ArithDouble=1, ArithInt16=2,
		ArithInt32=3, ArithFloat=4, MaxArithTypes=4};
	enum ArithCapabilities {
		ArithCapabilityFixed=	MaxArithTypes+1,
		ArithCapabilityAnyInt=	MaxArithTypes+2,
		ArithCapabilityAny=	MaxArithTypes+3,
		MaxArithCapabilities=	MaxArithTypes+3};
	static const char * CppNames[] ;
	static const double Accuracy[MaxArithTypes+1];
	static const char * target_sub_dir[MaxArithTypes+1];
	static const int SizeInBytes[MaxArithTypes+1];
	static const char * CapabilityNames[MaxArithCapabilities+2] ;
	static const char * ClassSuffix[MaxArithCapabilities+2] ;
	ArithType();
};
// stop ArithType definition (this line used in generating manual)
#endif


#endif /* #ifdef ARTHTYP_DOT_H */
