/*
 *  glistker.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProUsr/dsplstr.h"
#include "ObjProDSP/portable.h"
#include "ObjProGen/errcode.h"

class GenericList {
	int32 BlockSize ;
	int32 SampleSize ;
	int DisplayHandle ;
	DisplayNodeStr& TheNode ;

	int LineCount ;
	int WordWidth ;
	int NextWordIndex ;
	char SampleStartChar ;
	char SampleEndChar ;
	char SampleSeparate ;
	char BlockStartChar ;
	char BlockEndChar ;
	int32 BlockIndex ;
	int32 SampleIndex ;
	int32 WordIndex ;
	int32 StartLineOut ;
	uint32 hex_mask ;
	int LineStart ;
	char * MainTypeName ;

	int CharactersPerWord ;
	int32 CharactersPerSample ;
	int32 CharactersPerBlock ;
	int the_hex_flag ;
	int integer_read_flag ; 
	int CharIndex ;
	int LineWidth ;

	void CondOut(char c, char cc=0 ) ;
	void NewLine() ;
	void CheckNewLineSample() ;
	void CheckNewLineBlock() ;
	void CheckStartLineOut() ;
	void CheckSampleFit() ;
	void CheckBlockFit() ;
	ErrCode WriteBlock() ;
	ErrCode WriteSample(char BeginChar, char EndChar) ;
	void CheckHeaderLine() ;
	virtual int is_hex() const {return the_hex_flag;}
	void WriteValue() ;
public:
	GenericList (DisplayNodeStr& node, int disp_hand, int hex_flag,
		int read_integer);
	ErrCode List(int32 NumBlocks) ;
};


