/*
 *  block.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef BLOCK_DOT_H
#define BLOCK_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procstr.h"

class Block: public ProcessNodeStr {
#line 44 "../block.usr"
 
	enum convert_type {undefined,no_conversion, float_to_int,
		int_to_float} ;
#ifdef INTERACTIVE 
	int InitAfterLinked(); 
	void input_linked(int in_channel);
	void static_ctor();
#endif
	void ctor();
	ErrCode kernel(int32 k);
#line 31 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/block.h"
	int the_convert_type ;
	virtual ErrCode EmitStaticInit(OutTokens& Out);
	virtual ErrCode EmitStaticCtorParameters(OutTokens& Out);
	int16  ElementSize_1;
	int16  BlockSize_2;
	int16  OutputArithmetic_3;
public:
	Block (const char * Name, int16 ElementSize, int16 BlockSize, 
		int16 OutputArithmetic);
	virtual ~Block();
	int16 GetElementSize() const {return ElementSize_1;}
	int16 GetBlockSize() const {return BlockSize_2;}
	int16 GetOutputArithmetic() const {return OutputArithmetic_3;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
};

extern Block * BlockDef;


#endif /* #ifdef BLOCK_DOT_H */
