/*
 *  node.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef NODE_DOT_H
#define NODE_DOT_H
#include "ObjProDSP/timenum.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/strnode.h"

class Node: public DfNode {
	int16  in_1;
	int16  out_2;
	StreamStr* str_in_3;
	StreamStr* str_out_4;
	int32  NodeDelay_5;
	int32  DeltaIn_6;
	int32  DeltaOut_7;
	int32  Overlap_8;
	int32  DelayIn_9;
	TimingType  TheTimingType_10;
public:
	Node (const char * Name, int16 in, int16 out, StreamStr*str_in, 
		StreamStr*str_out, int32 NodeDelay, int32 DeltaIn, 
		int32 DeltaOut, int32 Overlap, int32 DelayIn, 
		TimingType TheTimingType);
	virtual ~Node();
	int16 Getin() const {return in_1;}
	int16 Getout() const {return out_2;}
	StreamStr*Getstr_in() const {return str_in_3;}
	StreamStr*Getstr_out() const {return str_out_4;}
	int32 GetNodeDelay() const {return NodeDelay_5;}
	int32 GetDeltaIn() const {return DeltaIn_6;}
	int32 GetDeltaOut() const {return DeltaOut_7;}
	int32 GetOverlap() const {return Overlap_8;}
	int32 GetDelayIn() const {return DelayIn_9;}
	TimingType GetTheTimingType() const {return TheTimingType_10;}
	virtual int CheckSafeDelete() ;
};


#endif /* #ifdef NODE_DOT_H */
