/*
 *  cmke.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
// This is program to recursively find all dependencies in
// several directories and construct a make file
// The basic structure assumed is follows:
//	list of library directories are input to program
//	Each library directory has a number of package subdirectories.
//	Each package has subdirectories:
//	c -- C code for objs
//	h -- header files
#include "ObjProGen/cpyrght_exe.h"
#include <iostream.h>
#include <stdlib.h>

#include "package.h"
#include "cmdline.h"
#include "dirdes.h"


main (const int argc, const char ** argv)
{
	PackageDesc * Package = CmdLineParse(argc, argv) ;
	// cout << "CmdLineParse done.\n" ;
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	Package->Init();
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	// cout << "Init done.\n" ;
	Package->FindFiles();
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	// cout << "FindFiles done.\n" ;
	Package->AddUserObjects();
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	// cout << "AddUserObjects done.\n" ;
	Package->MakeHeaderTable();
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	// cout << "MakeHeaderTable done.\n" ;
	Package->SortHeaderTable();
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	// cout << "SortHeaderTable done.\n" ;
	Package->GetDependencies();
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	// cout << "GetDependencies done.\n" ;
	Package->SolveDependencies();
	// cout << "SolveDependencies done.\n" ;
	Package->SetCDependencies();
	// cout << "SetCDependencies done.\n" ;
	// cerr << "Usr sub dir = `" << Package->UsrDirs->GetSubDir() << "'\n" ;
	Package->WriteMakes();
	// cout << "WriteMakes done.\n" ;
	Package->WriteSourceListings();
	// output listing for any collect library
	exit(0);
}
		
