/*
 *  classrel.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "slist.h"

class MenuItem ;
class MenuDef ;
class OutTokens ;

struct ClassRelation {
	const char * Derived ;
	const char * Base ;
	ClassRelation * BaseClass ; // if set then base class is derived
				    // from a lower base class
	ClassRelation * DerivedFromMe ; 
				    // to list of class derived from this base
	ClassRelation * BrotherDerivedFrom ;
					// to another class derived from same
					// base
	const MenuDef * TheMemberFunctionTree ;
	const MenuDef * TheMemberFunctionExecuteTree ;
	unsigned HasMembersDirect:1 ;
	unsigned HasMembersDerived:1 ;
	unsigned BaseTablePrinted:1 ;
	ClassRelation(const char * derived, const char * base) ;
	void SetMembers(const MenuDef * members) ;
	void SetMembersExec(const MenuDef * members) ;
	void SetTree(ClassRelation * base) ;
	void SetDerivedFromMe(ClassRelation * der) ;
	void SetBrother(ClassRelation * der) ;
	void Dump(OutTokens& Out) const ;
	const char * GetDerived() const {return Derived;}
	const char * GetBase() const {return Base;}

	void TeXOutDescribeRef(OutTokens& Out) const ;
	void TeXOutExecuteRef(OutTokens& Out) const ;

	int WriteClassTreeItem(OutTokens& Out, int i, int& ItemOut) ;
	void WriteItem(OutTokens& Out,int& ItemOut) ;
	int WriteClassTree(OutTokens& Out) ;
	void WriteClassTreeList(OutTokens& Out) ;
};

class ClassRelationList: public SingleList {
	ClassRelation * TheCurrentClass ;
	int DerivedSet ;
	ClassRelation ** BaseClassList ;

	void MakeClassTree(OutTokens& Out, ClassRelation* rel) ;
	void WriteClassTree(OutTokens& Out) ;
public:
	ErrCode Insert(ClassRelation *nt) {return SingleList::Insert(nt);}
	ErrCode Append(ClassRelation *nt) {return SingleList::Append(nt);}
	ClassRelation * Get()   {return (ClassRelation *) SingleList::Get();}
	ClassRelation * Pop() {return (ClassRelation *) SingleList::Pop();}
	ClassRelationList():
		TheCurrentClass(0),
		BaseClassList(0),
		DerivedSet(0) {}
	int Size(){return SingleList::Size();}
	void ClassHasMembers(const char * Name);
	int DoesClassHaveMembers(const char *Name);
	void SetDerivedMembers();

	void SetCurrentClass(ClassRelation * curr=0)
		{TheCurrentClass=curr;}
	const ClassRelation * GetCurrentClass() {return TheCurrentClass;}

	void FoundMenuDef(const MenuDef& item);

	void MakeClassTree(OutTokens& Out);
	void EmitTeXDescription(OutTokens& Out);
	const char * GetCurrentBaseClass() const ;
	const char * GetCurrentDerivedClass() const ;
	void Dump(OutTokens& Out);
	void TeXPrintClassHierarchy(OutTokens& Out);
	const char * GetDerived() const ;
	const char * GetBase() const ;
} ;

class ClassRelationListIterator: public SingleListIterator {
public:
	ClassRelationListIterator(ClassRelationList& df):
		SingleListIterator((SingleList&) df){}
	ClassRelation * operator()()
		{return (ClassRelation *) Next();}
};

extern ClassRelationList TheClassRelations;

