/*
 *  othbase.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <fstream.h>
#include "portable.h"
#include "y.tab.h"
#include "mknodey.h"
#include "domknode.h"
#include "slist.h"
#include "cgidbg.h"

class OtherCtor {
public:
	const int Type ;
	const char * Name ;
	const Compound * Exp ;
	OtherCtor(int type, const char * name, Compound * exp):
		Type(type),
		Name(name),
		Exp(exp)
	{}
	const char * GetType() const ;
	void EmitBaseClass(MofStream& HeaderOut) const ;
	void EmitCtor() const ;
};

void OtherCtor::EmitCtor() const 
{
	*CppOut << ",\n\t" << Name << "(" ;
	Exp->ExpOut(CppOut);
	*CppOut << ")" ;
}

void OtherCtor::EmitBaseClass(MofStream& HeaderOut) const 
{
	if (Type) HeaderOut << "," << GetType() << " " << Name ;
}

const char * OtherCtor::GetType() const 
{
	if (Type == PUBLIC) return "public" ;
	else if (Type == PRIVATE) return "private" ;
	else if (Type == PROTECTED) return "protected" ;
	else DbgError("OtherCtor::GetType","bad type");
	return 0 ;
}

class OtherCtorList:public SingleList {
public:
	ErrCode Insert(OtherCtor *nt) {return SingleList::Insert(nt);}
	ErrCode Append(OtherCtor *nt) {return SingleList::Append(nt);}
	OtherCtor * Get()   {return (OtherCtor *) SingleList::Get();}
	OtherCtor * Pop() {return (OtherCtor *) SingleList::Pop();}
	OtherCtor * GetNFromTop(int N) ;
	OtherCtor * GetNthEntry(int N) ;
	OtherCtorList(){;}
	int Size(){return SingleList::Size();}
} ;

class OtherCtorListIterator:public SingleListIterator {
public:
	OtherCtorListIterator(OtherCtorList& df):SingleListIterator((SingleList&) df){}
	OtherCtor * operator()()
		{return (OtherCtor *) Next();}
};

OtherCtorList TheOtherCtors ;

void FoundOtherCtor(int Type, const char * Name, Compound * Exp )
{
	TheOtherCtors.Append(new OtherCtor(Type,Name,Exp));
}

void EmitOtherBaseClasses(MofStream& HeaderOut)
{
	OtherCtorListIterator Next(TheOtherCtors);
	OtherCtor * Ctor ;
	while(Ctor = Next()) Ctor->EmitBaseClass(HeaderOut);
}

void EmitOtherBaseFunctionCtors()
{
	OtherCtorListIterator Next(TheOtherCtors);
	OtherCtor * Ctor ;
	while(Ctor = Next()) Ctor->EmitCtor();
}

