/*
 *  table.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
class OutTokens ;
struct FormatTranslate ;

class RoffTable {
	const char ** Options ;
	const char * Format ;
	OutTokens& Out ;
	const char * Caption ;
	const char * Label ;
	const char ** Items ;
	int ItemCount ;
	FormatTranslate * TheFormatTranslations ;
	int ItemIndex ;
	int LineCount ;
	enum {SaveIndexingSize=100} ;
	int SaveIndexing[SaveIndexingSize] ;
	int SaveIndex ;

	void Init() ;
	void ClearItems();
	const char * ConvertFormat() ;
	int CheckIndex(int Index) ;
	void Vspace() ;
	int IndexThisItem();
public:
	RoffTable(OutTokens& out, const char * caption=0, const char * lab=0);
	~RoffTable();
	void AddOption(const char * option);
	void AddFormat(const char * format);
	void NextEntry(const char * Entry);
	void Tab();
	void EndOfLine();
	void EndOfTable();
	void AddIndex(int index) ;
};
