# progress.tcl --
#
#	Implements a graphical progress bar.
#

namespace eval NSProgress {

proc NSProgress {oop parent width height color1 color2} {

	global NSProgress

	set frame $parent.progress$oop
	frame $frame -width $width -height $height -relief raised -borderwidth 1

	frame $frame.todo -relief sunken -borderwidth 1 -background $color2
	frame $frame.done -relief raised -borderwidth 1 -background $color1

	place $frame.todo -x 0 -y 0 -anchor nw -relwidth 1.0 -relheight 1.0
	place $frame.done -x 0 -y 0 -anchor nw -relwidth 0.5 -relheight 1.0

	set NSProgress($oop,frame) $frame
}

proc SetDoneRatio {oop ratio} {

	global NSProgress

	set frame $NSProgress($oop,frame)
	place configure $frame.done -relwidth $ratio
}

# namespace eval NSProgress
}
