# tomb.tcl --
#
#	The Kingly Window, Tomb Window and related commands.
#

proc KinglyWindow {} {

	global AngbandPriv
	global Windows

	#
	# Toplevel
	#

	set win .kingly
	toplevel $win
	wm title $win Winner!
	wm resizable $win no no

	# This window plays sound
	SoundWindow $win

	#
	# Font
	#

	set font [Global font,fixed,small]
	set fontWidth [font measure $font "W"]
	set fontHeight [font metrics $font -linespace]

	#
	# Main canvas
	#

	set c $win.canvas
	set wid [expr $fontWidth * 33]
	set hgt [expr $fontHeight * 20]
	canvas $c \
		-scrollregion "0 0 0 0" \
		-width $wid -height $hgt \
		-relief flat -highlightthickness 0 -background Black

	#
	# Canvas items
	#

	set center [expr $wid / 2]
	set y 0

	append kingly    "            #            \n"
	append kingly    "          #####          \n"
	append kingly    "            #            \n"
	append kingly    "      ,,,  $$$  ,,,      \n"
	append kingly    "  ,,=$   \"$$$$$\"   $=,,  \n"
	append kingly    ",$$        $$$        $$,\n"
	append kingly    "*>         <*>         <*\n"
	append kingly    "$$         $$$         $$\n"
	append kingly    "\"$$        $$$        $$\"\n"
	append kingly    " \"$$       $$$       $$\" \n"
	append kingly    "  *#########*#########*  \n"
	append kingly    "  *#########*#########*  \n"

	$c create text \
		$center [incr y $fontHeight] -fill White -font $font \
		-anchor n -justify center -text $kingly -fill Gold

    append message       "Veni, Vidi, Vici!\n"
    append message  "I came, I saw, I conquered!\n"
	if {[angband player sex] == "Male"} {
		append message   "All Hail the Mighty King!"
	} else {
		append message   "All Hail the Mighty Queen!"
	}

	incr y [expr $fontHeight * 14]
	$c create text \
		$center [incr y $fontHeight] -text $message -fill White \
		-font $font -justify center

	button $win.continue \
		-text "Continue" -width 11 -command "set AngbandPriv(result) 1"

	#
	# Geometry
	#

	pack $c \
		-expand no
	pack $win.continue \
		-side bottom -anchor center -pady 10

	# Position the window
	WindowPosition $win 2 3

	# Make sure the window is active
	focus $win


	# DirectSound sees child windows as the parent window, and
	# will play sound when either the parent or one of its children
	# is active. But the Tomb Window is not a child window, so we
	# must mark it as a "sound window".
	angband sound window $win

	# If you close ALL the windows, the application swaps into
	# the background. So we delay closing the other windows until here.
	foreach name [array names Windows "*,win"] {
		wm withdraw $Windows($name)
	}

	# Hack -- Quit without saving
	bind $win <KeyPress-a> {angband game abort}

	# Quit with save if window is closed
	bind $win <Destroy> {set AngbandPriv(result) 1}

	# Set a grab on the window and claim the focus
	NSUtils::GrabSave $win
	focus $win

	vwait AngbandPriv(result)

	# Release grab
	NSUtils::GrabRelease $win

	catch {
		bind $win <Destroy> {}
#		destroy $win
	}
}

proc TombWindow {} {

	global AngbandPriv
	global Windows

	#
	# Toplevel
	#

	set win .tomb
	toplevel $win
	wm title $win Tomb
	wm resizable $win no no

	# This window plays sound
	SoundWindow $win

	#
	# Font
	#

	set font [Global font,fixed,small]
	set fontWidth [font measure $font "W"]
	set fontHeight [font metrics $font -linespace]

	#
	# Main canvas
	#

	set c $win.canvas
	set wid [expr $fontWidth * 40]
	set hgt [expr $fontHeight * 20]
	canvas $c \
		-scrollregion "0 0 0 0" \
		-width $wid -height $hgt \
		-relief flat -highlightthickness 0 -background Black

	#
	# Canvas items
	#

	set center [expr $wid / 2]
	set y [expr $fontHeight * 2]

	$c create text \
		$center [incr y $fontHeight] -text RIP -fill White -font $font \
		-justify center
	incr y $fontHeight

	$c create text \
		$center [incr y $fontHeight] -text [angband player name] -fill White \
		-font $font -justify center
	$c create text \
		$center [incr y $fontHeight] -text the -fill White -font $font \
		-justify center
	$c create text \
		$center [incr y $fontHeight] -text [angband player title] -fill White \
		-font $font -justify center
	incr y $fontHeight

	$c create text \
		$center [incr y $fontHeight] -text [angband player class] -fill White -font $font -justify center
	$c create text \
		$center [incr y $fontHeight] -text "Level: [angband player level]" \
		-fill White -font $font -justify center
	$c create text \
		$center [incr y $fontHeight] -text "Exp: [lindex [angband player exp] 0]" \
		-fill White -font $font -justify center
	$c create text \
		$center [incr y $fontHeight] -text "AU: [angband player gold]" \
		-fill White -font $font -justify center
	$c create text \
		$center [incr y $fontHeight] -text "Killed on Level [angband player depth]" \
		-fill White -font $font -justify center
	$c create text \
		$center [incr y $fontHeight] -text "by [angband player died_from]" \
		-fill White -font $font -justify center
	incr y $fontHeight

	$c create text \
		$center [incr y $fontHeight] -text [clock format [clock seconds] \
		-format "%a %b %d %H:%M:%S %Y"] -fill White -font $font \
		-justify center

	button $win.quit \
		-text "Save & Quit" -width 11 -command "set AngbandPriv(result) 1"
	button $win.file \
		-text File -width 9 -command "FileCharacter $win"
	button $win.messages \
		-text Messages -width 9 -command "NSMessage::Dump \$Windows(messages,oop) $win"

	#
	# Geometry
	#

	pack $c \
		-expand no
	pack $win.quit \
		-side bottom -anchor e -pady 10 -padx 10
	place $win.file \
		-in $win.quit -bordermode outside -relx 0.0 -x -10 -anchor ne
	place $win.messages \
		-in $win.file -bordermode outside -relx 0.0 -x -10 -anchor ne

	# Character image
	incr y [expr $fontHeight + 16]
	set size [icon size]
	set icon [angband player char_attr]
	$c create widget $center $y -anchor center -type [lindex $icon 0] \
		-index [lindex $icon 1]

	# Position the window
	WindowPosition $win 2 3

	# Make sure the window is active
	focus $win


	# DirectSound sees child windows as the parent window, and
	# will play sound when either the parent or one of its children
	# is active. But the Tomb Window is not a child window, so we
	# must mark it as a "sound window".
	angband sound window $win


	# If you close ALL the windows, the application swaps into
	# the background. So we delay closing the other windows until here.
	if {[winfo exists .kingly]} {
		wm withdraw .kingly
	}
	foreach name [array names Windows "*,win"] {
		wm withdraw $Windows($name)
	}

	# Hack -- Quit without saving
	bind $win <KeyPress-a> {angband game abort}

	# Quit with save if window is closed
	bind $win <Destroy> {set AngbandPriv(result) 1}

	# Set a grab on the window and claim the focus
	NSUtils::GrabSave $win
	focus $win

	vwait AngbandPriv(result)

	# Release grab
	NSUtils::GrabRelease $win

	catch {
		bind $win <Destroy> {}
#		destroy $win
	}
}

proc FileCharacter parent {

	global Angband

	set initial [angband player base_name].txt
	set filename [tk_getSaveFile -initialfile $initial \
		-initialdir [file join $Angband(dir) lib user] -parent $parent]
	if {![string compare $filename ""]} return

	if {[catch {angband game file_character $filename} result]} {
		tk_messageBox -icon error -message $result
	}
}
