private static int is_wielded;
private int max_damage_beginner, max_damage_expert;
private string *skill_definition;
private int *used_stats, total_stat;
private int learning_type;

int do_wield() {
    int i;
    is_wielded = 1;
    total_stat = 0;
    if (used_stats) {
	for (i=0; i < sizeof(used_stats); i++)
	    total_stat += (int)this_player()->query_stat(used_stats[i]);
    }
    return 1;
}

/*
 * This one is called only to tell the weapon that it is not wielded any more.
 */
void stop_wield() {
    is_wielded = 0;
}

int query_wield() {
    return is_wielded;
}

/*
 * Initialize a weapon. There are 4 arguments:
 *
 * skill: The array of strings, defining of what skill this weapon
 * belongs to. An example is ({ "skill", "offensive", "sharp", "knife" }).
 *
 * stats: An array of integers, defining what stats are good to have for
 * this weapon. Example: ({ STAT_STR, STAT_DEX }). It is possible to have
 * the same stat several times, which will add extra weight for that
 * stat.
 *
 * max_beg: How much damage an utter novice will be able to do if lucky.
 *
 * max_exp: How much maximal damage an expert player will do with this
 * weapon.
 *
 * learn_type: Choose one type from config.h, LEARNING_X etc.
 */
void init_weapon_data(string *skill, int *stats, int max_beg, int max_exp,
		      int learn_type) {
    skill_definition = skill;
    learning_type = learn_type;
    used_stats = stats;
    max_damage_expert = max_exp;
    max_damage_beginner = max_beg;
}

string *query_skill() {
    return skill_definition;
}

int query_max_damage() {
    return max_damage_expert;
}

/*
 * The player object asks how much damage this weapon will do
 * for every hit.
 */
int compute_damage(int total_skill) {
    int tmp;
    if (sizeof(used_stats) == 0)
	return 0;
    tmp = (max_damage_expert - max_damage_beginner) *
	(total_skill + total_stat / sizeof(used_stats)) +
	    max_damage_beginner * 100;
    if (tmp == 0)
	return 0;
    return random(tmp) / 100;
}

int query_learning_type() {
    return learning_type;
}

/*
 * Reward for this object being used. Multiply by 'factor'.
 * This function is not called every time a reward would be needed,
 * but only a fraction. The 'factor' compensates for this fraction.
 */
void reward_usage(object player, int factor) {
    int i;

    player->add_skill_points(skill_definition, learning_type * factor);
}
