/*
 * This is the room that defines the entrance to the hedge in
 * the center.
 */

inherit "/room/map/base";
inherit "/basic/id";

string query_short() {
    return "Hedge";
}

string query_long(string str) {
    if (str == "hedge")
	return "There is a small hole in the hedge. You might enter it,\n" +
	    "but maybe not be able to go back again.\n";
    return "There is a small square hedge here. Somehow, you feel like\n" +
	"you are in the center of the world.\n";
}

/*
 * Do not let master.c remove this file !
 */
int volatile() {
    return 0;
}

void create() {
    set_id( ({ "hedge" }) );
    base::create();
}

void init() {
    base::init();
    add_action("enter", "enter");
}

int enter(string str) {
    if (str && str != "hedge" && str != "hole" && str != "hole in hedge") {
	notify_fail("Enter what ?\n");
	return 0;
    }
    this_player()->move_player("/room/start1",
			       "enter a small hole in the hedge.\n");
    return 1;
}
