#include "move_failure.h"

int drop_command(string str) {
    object ob;
    int res;

    if (!str) {
	notify_fail("Drop what ?\n");
	return 0;
    }
    ob = present(str, this_player());
    if (!ob) {
	notify_fail("What " + str + "?\n");
	return 0;
    }
    res = (int)ob->move(environment(this_player()));
    if (res == MOVE_OK) {
	this_object()->message("drops " + (string)ob->query_sort(), 0, 0);
	write("Ok.\n");
	return 1;
    }
    if (res == MOVE_NOT_ALLOWED)
	notify_fail("You can't do that.\n");
    else if (res == MOVE_NO_ROOM)
	notify_fail("Not enough room.\n");
    return 0;
}
