/*
 * Imperium
 *
 * Copyright (C) 1990-93 by David Wright
 *
 * $Id: Combat.h,v 3.4.1.2 1993/11/26 04:58:33 davewt Exp $
 *
 * definitions private to combat-related functions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: Combat.h,v $
 * Revision 3.4.1.2  1993/11/26  04:58:33  davewt
 * patch8: Changed definition of pickBestWeap() in Combat.h
 *
 * Revision 3.4.1.1  1993/11/19  06:22:52  davewt
 * patch3: New base revision.
 *
 * Revision 3.4.1.1  1993/11/19  06:05:03  davewt
 * patch3: Test revision
 *
 * Revision 3.4  1993/10/16  05:01:40  davewt
 * New revision.
 *
 * Revision 3.3  1993/10/16  04:33:35  davewt
 * New  release.
 *
 * Revision 3.2  1993/10/07  02:06:44  davewt
 * New branch release.
 *
 * Revision 3.1.1.1  1993/09/07  01:52:21  davewt
 * patch1: First patch to initial version.
 *
 *
 */

/*
 * Note that this file has some dependancies on things declared in
 * Imperium.h (mainly the weapon types). This had to be done to avoid
 * either putting all the combat-related definitions in Imperium.h, which
 * is already to big and contains things not needed by all modules, or
 * avoid putting the things that this file depended on in here, thus forcing
 * more modules than need to to include this file.
 *
 * Basically, the things in Imperium.h are of general interest, while the
 * things in this file are of interest only to routines that directly
 * handle combat.
 */

/*
 * weapons.c
 */

/* Picks the best "beam" weapon to use */
BigPart_t pickBestBeam(IMP, register Ship_t *);
/* Picks the best "projectile" weapon to use */
BigPart_t pickBestProj(IMP, register Ship_t *);
/* Picks the "best" weapon to use of either type */
BigPart_t pickBestWeap(IMP, register Ship_t *, ULONG, BOOL, USHORT, USHORT);

BOOL hasBeam(IMP, register Ship_t *);   /* Ship has a beam weapon */
BOOL hasProj(IMP, register Ship_t *);   /* Ship has a projectile weapon */
BOOL hasWeap(IMP, register Ship_t *);

/* Picks the amount to try and fire - for use in defending a ship */
USHORT pickAmtToFire(IMP, register Ship_t *, BigPart_t, BOOL);
