// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.


#include "Explosion.h"


PtrList<Explosion> Boom::list;


Explosion::Explosion( FixedPoint Fxp, FixedPoint Fyp, int size, int dur,
		      FixedPoint Fxv, FixedPoint Fyv )
		      : Vsize(size), Life(dur)
	{
	if (Vsize > BMAX) Vsize=BMAX;

	register int i;
	
	for(i=0; i<Vsize; i++)
		{
		Vbit[i].setFpos(Fxp,Fyp);
		Vbit[i].randomDir( INT2FP((rand()>>2)&63 + 24)>>4 );
		Vbit[i].addVel( Fxv, Fyv );
		Vbit[i].Vcolor = ((rand()&255)>127) ? 254 : 253;
		}
	}

void Boom::tick()
	{
    	Explosion* e;
    	list.gotoFirst();
    	while ( (e=list.current())!=NULL)
    		{
    		e->tick(); 
    		if (!e->isAlive()) list.remove();
    		else	list.gotoNext();
    		}
    	}

void Boom::draw()
	{
    	Explosion* e;
    	list.gotoFirst();
    	while ( (e=list.current())!=NULL)
    		{
    		e->draw(); 
    		list.gotoNext();
    		}
    	}

