#ifndef _CITY_H
#define _CITY_H

#include "mytypes.h"
#include "list.h"

class MsgQ;
class Player;

typedef List<charp> StrList;

class City
{
public:
  City(char *Name, ulong Id, int X, int Y, uchar OwnerId);
  City(); // read from save file
  ~City();

  // do end of turn update for this city
  // fails if the city dies
  int Update();

  void Draw(int atx, int aty);

  ulong id;
  char *name;
  int x, y;
  uchar ownerId;

  List<ulong> units;

  int prod, food, trade, tradeBonus;
  int science, money, luxuries;
  int surpProd;
  int corruption; // not used yet
  int pollution; // not used yet

  int size;
  int working, elvi, goondas, happy;

  char *building;
  int accProd, needProd;

  int foodStored, foodSupport;
  int foodStoreCap;

  List<charp> buildings; // things we have built in the city

  List<charp> messages; // messages to show for this city

  char *LookupBuilding(char *, int);

  void Save();

  void SendCapturedInfo(MsgQ *q);

  void WorkOn(char *what); // what we should work on

  void InfoScreen(); // draws the whole info screen

  // functions to draw various components, call them if you update
  // any of the city variables
  void DrawBasic();
  void DrawCityMap();
  void ShowPeople();
  void ShowEcon();
  void ShowFood();
  void ShowOwnUnits();
  void ShowStationedUnits();
  void ShowWorkInProg();
  void ShowBuildings();

  void ComputeEcon();

  friend void AllocCityColors();

  void PutExtraWorker();
  void DrawIfVisible();

  char *MakeWorkMap(int &len);
  void TransWorkMap(MsgQ *q);

  // returns a list of things we can build
  StrList CanBuild();

  void TakeHit(); // city attacked

  int HasBuilding(char *);

  static int white; // white color for writing text
  static int black, red;
  static int back;

  static long hBulb, hElvis, hFood, hGoonda, hLux, hMoney, hShield, hTrade;
  static long hWorker;

private:

  void PutIcon(long, int, int &, int &, int, int, int);

  void Produce();
};

void GetCapturedCity(MsgQ *q, Player *p);

#endif
