#ifndef _DISPLAY_H
#define _DISPLAY_H

#include "mytypes.h"

class City;

class World;

class Unit;

// displays a little window on the world
// you can activate a cursor which will flash on a specified unit
// the cursor will only flash if you tell it to
class WDisplay
{
public:
  WDisplay(World *world);
  ~WDisplay();

  void Message(int color, char *format, ...);

  void AllocColors();

  void Update();

  void ShowMap();
  void ShowCityInfo(City *);
  void ShowPlayerInfo();
  City *CurrCity() { return city; }

  int InMap() { return where == SHOWING_MAP; }
  int InCity() { return where == SHOWING_CITY; }

  void ShowPiece(int worldx, int worldy, ulong id);

  void ShowCity(int worldx, int worldy, ulong id);

  void ScrollUp();
  void ScrollDown();
  void ScrollLeft();
  void ScrollRight();

  void TranslateScreen(int worldx, int worldy, int &screenx, int &screeny);

  void TranslateWorld(int screenx, int screeny, int &worldx, int &worldy);

  void EnableCursor(int worldx, int worldy, ulong id);
  void DisableCursor();

  int Visible(int worldx, int worldy);

  void Center(int sx, int sy);

private:
  enum { SHOWING_CITY, SHOWING_MAP };

  int where; // SHOWING_CITY or SHOWING_MAP

  City *city; // if we're showing a city

  static int white; // white color

  int maxX, maxY;

  int left, top; // top left corner of the screen

  int cursorx, cursory;
  int cursorsx, cursorsy;
  Unit *cursorUnit;

  friend void DisplayCursor(int);

  void BlitMap(int x1, int y1, int w, int h, int x2, int y2);
};

// should be hooked into the timer otherwise no cursor will showup
void DisplayCursor(int);

#endif
