#ifndef _RIVERS_H
#define _RIVERS_H

class MsgQ;

class Rivers
{
public:
  Rivers(int NumRivers, int RiverLength, World *pworld);
  Rivers(World *pworld); // get from save file
  Rivers(MsgQ *, World *pworld); // get from socket
  ~Rivers();
  
  void Save();
  
  void DrawRiver(int x, int y, int atx, int aty);

  void Send(MsgQ *); // send over the socket

private:

  class RiverInfo {
  public:
    RiverInfo() { NumPts = 0; riverId = 0; }

    int NumPts;
    int riverId;
    int pts[3];
  };

  World *world;
  RiverInfo *riverInfo; // used only to create the rivers
  int riverId; // used only to create the rivers

  RiverInfo &Get(int x, int y) { return riverInfo[y*world->MaxX()+x]; }

  char *riverMap;

  void RiverEnd(int &ex, int &ey, int &dir);

  // returns 1 if ok
  // returns 2 if can't go any further
  // returns 3 if will hit another river on the move
  int PickNewDir(int x, int y, int fromdir, int &x1, int &y1, int &dir);

  void AddPiece(int x, int y, int fromdir, int todir);

  void NewRiver(int riverLength);

  void ConvDir(int x, int y, int dir, int &x1, int &y1);
};

#endif
