/*
 * This file is supposed to get over any machine-dependent
 * problems.  Some, like ulimit(2) are fixed in the kernel (usually);
 * the rest are up to us users to work out
*/
/*

    3Dc, a game of 3-Dimensional Chess
    Copyright (C) 1995  Paul Hicks

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    E-Mail: P.Hicks@net-cs.ucd.ie
*/
#ifndef _3DC_MACHINE_H
#define _3DC_MACHINE_H

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_ULIMIT_H
#include <ulimit.h>
#endif

#ifdef __sun__
/* Sun don't include function definitions (idiots!) */

#ifdef FILE /* stdio.h doesn't have a wrapper on suns... */
extern int fprintf(FILE *, char *, ...);
#endif /* FILE */
extern int printf(char *, ...);
extern void bzero(char *, int);
extern long random(void);
extern void srandom(int);

#ifdef __sys_types_h
#ifdef _sys_time_h
extern int select(int, fd_set *, fd_set *, fd_set *, struct timeval *);
#endif _sys_time_h
#endif /* __sys_types_h */

extern long ulimit(int, long);
extern int close(int);
extern int write(int, char *, int);
extern int read(int, char *, int);
extern int socket(int, int, int);
extern int setsockopt(int, int, int, char *, int);
typedef struct sockaddr_in *SOCKADDR;

#ifdef _netinet_in_h
extern int bind(int, struct sockaddr_in *, int);
extern int connect(int, struct sockaddr_in *, int);
extern int accept(int, struct sockaddr_in *, int *);
#endif /* _netinet_in_h */

extern int listen(int, int);
#else
typedef struct sockaddr *SOCKADDR;
#endif /* __sun__ */

#ifdef __alpha__
#include <alloca.h>
#endif /* __alpha__ */

#ifdef __GNUC__
#define INLINE __inline__
#else
#define INLINE
#endif /* __GNUC__ */

#endif /* _3DC_MACHINE_H */
