/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 1993, 1994, 1995, Elan Feingold (feingold@zko.dec.com)     *
 *                                                                           *
 *     PERMISSION TO USE, COPY, MODIFY, AND TO DISTRIBUTE THIS SOFTWARE      *
 *     AND ITS DOCUMENTATION FOR ANY PURPOSE IS HEREBY GRANTED WITHOUT       *
 *     FEE, PROVIDED THAT THE ABOVE COPYRIGHT NOTICE APPEAR IN ALL           *
 *     COPIES AND MODIFIED COPIES AND THAT BOTH THAT COPYRIGHT NOTICE AND    *
 *     THIS PERMISSION NOTICE APPEAR IN SUPPORTING DOCUMENTATION.  THERE     *
 *     IS NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR      *
 *     ANY PURPOSE.  THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS       *
 *     OR IMPLIED WARRANTY.                                                  *
 *                                                                           *
 *****************************************************************************/

#ifndef _NETWORK
#define _NETWORK

#include <sys/types.h>

#include "types.h"

/****************/
/* The Messages */
/****************/

#define MSG_REGISTERCLIENT   0x01
typedef struct _msgRegisterClient
{
  CString strClientAddress;
} MsgRegisterClient;

#define MSG_EXCHANGECARDS      0x03
typedef struct _msgExchangeCards
{
  Int32 piCards[3];
} MsgExchangeCards;

#define MSG_REQUESTCARD      0x04
typedef struct _msgRequestCard
{
  Int32 iPlayer;
} MsgRequestCard;

#define MSG_CARDPACKET       0x05
typedef struct _msgCardPacket
{
  Int32  iPlayer;
  Int32  cdCard;
} MsgCardPacket;

#define MSG_REPLYPACKET      0x06
typedef struct _msgReplyPacket
{
  Int32 iReply;
} MsgReplyPacket;

#define MSG_SENDMESSAGE      0x07
typedef struct _msgSendMessage
{
  CString strMessage;
  CString strDestination;
} MsgSendMessage;


#define MSG_MESSAGEPACKET    0x08
typedef struct _msgMessagePacket
{
  CString  strMessage;
  CString  strFrom;
  Int32    iTo;
} MsgMessagePacket;

#define DST_ALLPLAYERS -1
#define DST_ALLBUTME   -2
#define DST_OTHER      -3

#define MSG_EXIT        0x09
#define MSG_STARTGAME   0x0A

#define MSG_TURNNOTIFY  0x0B
typedef struct _msgTurnNotify
{
  Int32 iPlayer;
  Int32 iClient;
} MsgTurnNotify;

#define MSG_ENDTURN     0x0C

#define MSG_CLIENTIDENT 0x0D
typedef struct _msgClientIdent
{
  Int32 iClientID;
} MsgClientIdent;

#define MSG_ENTERSTATE  0x0E
typedef struct _msgEnterState
{
  Int32 iState;
} MsgEnterState;

#define MSG_ENDOFGAME   0x10
typedef struct _msgEndOfGame
{
  Int32 iWinner;
} MsgEndOfGame;

#define MSG_OBJSTRUPDATE 0x11
typedef struct _msgObjStrUpdate
{
  Int32     iField;
  Int32     iIndex1, iIndex2;
  CString  strNewValue;
} MsgObjStrUpdate;

#define MSG_OBJINTUPDATE 0x12
typedef struct _msgObjIntUpdate
{
  Int32     iField;
  Int32     iIndex1, iIndex2;
  Int32     iNewValue;
} MsgObjIntUpdate;

#define MSG_GAMENEWPLAYERS   0x13
#define MSG_GAMEMOREPLAYERS  0x14
#define MSG_SAMEPLAYERS      0x15
#define MSG_DEREGISTERCLIENT 0x16
#define MSG_ALLOCPLAYER      0x19

#define MSG_FREEPLAYER       0x20
typedef struct _msgFreePlayer
{
  Int32 iPlayer;
} MsgFreePlayer;

#define MSG_NETMESSAGE       0x21
typedef struct _msgNetMessage
{
  CString strMessage;
} MsgNetMessage;

#define MSG_NETPOPUP         0x22
typedef struct _msgNetPopup
{
  CString strMessage;
} MsgNetPopup;

#define MSG_POPUPREGISTERBOX 0x23

#define MSG_DICEROLL         0x24
typedef struct _msgDiceRoll
{
  Int32 iDefendingPlayer;
  Int32 pAttackDice[3];
  Int32 pDefendDice[3];
} MsgDiceRoll;

#define MSG_PLACENOTIFY      0x25
typedef struct _msgPlaceNotify
{
  Int32 iCountry;
} MsgPlaceNotify;

#define MSG_ATTACKNOTIFY     0x26
typedef struct _msgAttackNotify
{
  Int32 iSrcCountry;
  Int32 iDstCountry;
} MsgAttackNotify;

#define MSG_MOVENOTIFY       0x27
typedef struct _msgMoveNotify
{
  Int32 iSrcCountry;
  Int32 iDstCountry;
} MsgMoveNotify;

#define MSG_POLLCLIENTS      0x28
typedef struct _msgPollClients
{
  CString strPollQuestion;
} MsgPollClients;

#define MSG_METASERVERINFO   0x29
typedef struct _msgMetaServerInfo
{
  CString strMyAddress;
} MsgMetaServerInfo;

Int32  NET_SendMessage(Int32 iSocket, Int32 iMessType, void *pvMessage);
Int32  NET_RecvMessage(Int32 iSocket, Int32 *piMessType, void **pvMessage);
void   NET_DeleteMessage(Int32 iMessType, void *pvMessage);
Int32  NET_SendSyncMessage(Int32 iSocket, Int32 iMessType, void *pvMessage, 
			   Int32 iReturnMessType,
			   void (*CBK_MessageReceived)(Int32, void *));
#endif
