/*

GBM.H  General Bitmap Code

Data is stored as an array of lines.
Lines are stored with bottom line first, moving upwards.
Each line is an array of pixels, leftmost first.
Lines are padded to be a multiple of a dword long.
Palettised pixels are either a 1 bit, 4 bit, or 8 bit indexes.
Alternately a B, G, R triple in that order is stored.
This format exactly matches the format used by OS/2 1.2 bitmaps.

*/

typedef int GBM_ERR;
#define	GBM_ERR_OK		((GBM_ERR) 0)
#define	GBM_ERR_MEM		((GBM_ERR) 1)
#define	GBM_ERR_NOT_SUPP	((GBM_ERR) 2)
#define	GBM_ERR_BAD_OPTION	((GBM_ERR) 3)
#define	GBM_ERR_NOT_FOUND	((GBM_ERR) 4)
#define	GBM_ERR_BAD_MAGIC	((GBM_ERR) 5)
#define	GBM_ERR_BAD_SIZE	((GBM_ERR) 6)
#define	GBM_ERR_READ		((GBM_ERR) 7)
#define	GBM_ERR_WRITE		((GBM_ERR) 8)

#define	GBM_FT_R1		0x0001
#define	GBM_FT_R4		0x0002
#define	GBM_FT_R8		0x0004
#define	GBM_FT_R24		0x0008
#define	GBM_FT_W1		0x0010
#define	GBM_FT_W4		0x0020
#define	GBM_FT_W8		0x0040
#define	GBM_FT_W24		0x0080

typedef struct
	{
	char	*short_name;		/* Eg: "Targa"                       */
	char	*long_name;		/* Eg: "Truevision Targa / Vista"    */
	char	*extensions;		/* Eg: "TGA VST"                     */
	int	flags;			/* What functionality exists         */
	} GBMFT;

typedef struct { byte r, g, b; } GBMRGB;

#define	PRIV_SIZE	2000

typedef struct
	{
	int	w, h, bpp;		/* Bitmap dimensions                 */
	byte	priv [PRIV_SIZE];	/* Private internal buffer           */
	} GBM;

#ifndef _GBM_

GBM_ERR gbm_init(void);
GBM_ERR gbm_deinit(void);

GBM_ERR gbm_query_n_filetypes(int *n_ft);
GBM_ERR gbm_query_filetype(int ft, GBMFT *gbmft);
GBM_ERR gbm_guess_filetype(char *fn, int *ft);

GBM_ERR gbm_read_header(char *fn, int fd, int ft, GBM *gbm, char *opt);
GBM_ERR gbm_read_palette(int fd, int ft, GBM *gbm, GBMRGB *gbmrgb);
GBM_ERR gbm_read_data(int fd, int ft, GBM *gbm, byte *data);
GBM_ERR gbm_write(char *fn, int fd, int ft, GBM *gbm, GBMRGB *gbmrgb, byte *data, char *opt);
char *gbm_err(GBM_ERR rc);

#endif
