/* mphead.h */

#define NULL			0

#define I_TYPE			1
#define P_TYPE			2
#define B_TYPE			3

#define DISPLAY_LOCK		1
#define PAST_LOCK		2
#define FUTURE_LOCK		4

#define ESCAPE			61
#define END_OF_BLOCK		62

#define LEVEL_MASK		63
#define NUM_MASK		15
#define RUN_SHIFT		10
#define LEVEL_SHIFT		4

#define RING_BUF_SIZE 		5

extern unsigned bit_buf;
extern bit_num;
extern unsigned char *buf_point,*buf_check;

#define fill_bitsn(n)		(bit_num<(n) ? fill_bits() : 0)

#define get_bitsn(n)		(bit_buf>>(bit_num-=(n))&(1<<(n))-1)
#define show_bitsn(n)		(bit_buf>>bit_num-(n)&(1<<(n))-1)
#define flush_bitsn(n)		(bit_num-=(n))

#define SEQ_END_CODE		0x000001b7
#define SEQ_START_CODE		0x000001b3
#define GOP_START_CODE		0x000001b8
#define PICTURE_START_CODE	0x00000100
#define SLICE_MIN_START_CODE	0x00000101
#define SLICE_MAX_START_CODE	0x000001af
#define EXT_START_CODE		0x000001b5
#define USER_START_CODE		0x000001b2

#define MB_STUFFING		34
#define MB_ESCAPE		35

struct pict_image {
	unsigned char *o[6];
	unsigned char *lum,*cr,*cb;
	int lock;
};
