// PMS-view.c : main program for online view of pictures from the PMS-board
//  a part of PMS-grabber package
// the "GNU Public Lincense" policy applies to all programs of this package
// (c) Wolfgang Koehler, wolf@first.gmd.de, Dec. 1994
//     Kiefernring 15
//     14478 Potsdam, Germany
//     0331-863238

#include "window.h"
#include "grabber.h"
#include "ximage.h"
#include "evaluation.h"
#include "view.h"

void update_register_window();

// general setting fuction, also updates register windows     
void option_update(option_struct *osp, int value) {
  osp->iCurrent = value;
  osp->SetFunction(value);
  show_capt(); // let see new picture
  update_register_window();  // show changed registers
}
 
typedef void (*MCB)(void*);

// this-pointer als Arg fuer scroller_cb (scrollbar constructor typ 2) 
// damit wird die Element-function scroller_cb als callback aufgerufen !!!
class option_scrollbar : public scrollbar {
Bool update;
public:
  option_struct *osp;
  scroller_cb() { 
    if (update) option_update(osp,value);
  }
  option_scrollbar(window &parent, option_struct *opti, 
		int w, int h, int x, int y)
  : scrollbar(parent, (MCB) (&option_scrollbar::scroller_cb), this,
	       w,h,x,y,opti->iMin,opti->iMax,opti->iCurrent,"%3d") 
   { osp = opti; update = True; }
  // setzen des sliders, ohne Aufruf von option_update !
  set_current() { 
    update = ! update; change(osp->iCurrent); update = !update;} 
};

class option_toggle : public toggle_button {  
option_struct *osp;
public:
  option_toggle(window &parent, option_struct *opti,int w, int h,int x,int y) :
    toggle_button(parent,opti->Desc,&opti->iCurrent,w,h,x,y) { osp = opti; }
  virtual void toggle_cb(int val) { 
    option_update(osp,osp->iCurrent); 
  }
};

// fuer die radio_menues zur selection : action method aktiviert 
// und Azeigen des aktuellen strings 
class option_text: public window {
option_struct *opti;
public:
  option_text(window &parent, option_struct *opti, int w,int h, int x, int y) :
    window(parent,w,h,x,y,0), opti(opti) { }

  virtual void redraw() { 
   char *text = *(opti->OptionList + opti->iMin + opti->iCurrent);
   clear(); PlaceText(text);  }

  virtual void action(char *menu, char* valstr) {
    option_struct *opti = option_vector;
    while (opti->Desc != menu) opti++; 
    int value = opti->iMin;
    char **entry = opti->OptionList;
    while (*entry != valstr) { entry++; value++; }
    // printf(" %s %d \n",opti->Desc,value);
    option_update(opti,value); 
    redraw();
  }
};

option_scrollbar *oscb[10]; // max 10 scrollbars in option_window
int nscr = 0; 
option_toggle *otb[10]; // max 10 option_toggle
int ntb = 0;
option_text *otew[10];
int ntew = 0;

void reset_defs() { 
  all_defaults(); // Setzen aller Parameter auf def
  int i;
  for (i=0; i<nscr; i++) oscb[i]->set_current();  // setzen der scrollbars
  for (i=0; i<ntb; i++) otb[i]->picture(); // Zeichnen der toggle states
  for (i=0; i<ntew; i++) otew[i]->redraw();
  update_register_window(); // nur einmal !
}

void set_resolution() {
  printf("setting resolution to %d x %d\n",biWidth,biHeight);
  SetMVVResolution(biWidth, biHeight);
}

// Setzt res. auf globale Werte, erzeugt buffer & Image
void create_buffers_resolution() {
  set_resolution();
  update_register_window();
  create_buffers(biWidth,biHeight);
}  

scrollbar *sizer;

// setzt resolution, initialisiert arrays, image buffer
// fuer  sizer scrollbar, auch in der Initialisierung von main aufgerufen !
void set_sizer() { 
  int ww = sizer->value & ~1; // even
  biWidth = ww; biHeight = biWidth*3/4;
  printf("set_sizer\n");
  create_buffers_resolution();
  grab_wi->resize(biWidth,biHeight);
}  

// popup window zum Einstellen aller Parameter
class option_popup : public main_window { 
public: 
  option_popup(char *Name) : main_window(Name,350,510) {
    int w = 350;
    int i, ysc = 0, ysb = 0, yst = 370, wb = 120, x1 = 10, x2 = 220;
    for(i=0; i< noptions;i++) {
      option_struct *opti = option_vector+i;
      // int nopt = opti->iMax - opti->iMin;
      if (opti->OptionList == NULL) {
	new text_win(*this,opti->Desc,200,20,10,ysc); 
	oscb[nscr++] = new option_scrollbar(*this, opti,200,20,10,ysc+20); 
	ysc+= 40;
      } else if (opti->OptionList == &toggle_switch) {
	int x = (ntb & 1) ? x2 : x1;
	otb[ntb++] = new option_toggle(*this,opti,wb,20,x,yst);
	if (x == x2) yst+= 30;
      } else {
	otew[ntew] = new option_text(*this,opti,wb,20,x2,ysb);
	make_radio_menu(*this, opti->Desc, opti->OptionList, otew[ntew],
			wb,20,x2,ysb+20);
	ntew++; ysb+= 40;
      }
    } 
    new callback_button(*this,"defaults",&reset_defs,
			wb,20,x2,yst);
    new unmap_button(*this,"close",70,20,140,yst);
    new text_win(*this,"resolution",w,20,0,yst+20); 
    sizer = new scrollbar(*this,set_sizer,w-20,20,10,yst+40,10,500,biWidth);
  }
};

// display one register, 
class register_window : public plate {
int reg; 
int oldval;
public: 
  register_window(window &parent, int reg, int w,int h, int x, int y) :
    plate(parent,w,h,x,y,down3d), reg(reg) { }

  // setzen val_str in edit_window und drawing
  void update(int val) { 
    char str[5];
    sprintf(str,"%4d",val); 
    PlaceText(str);
    oldval = val;
  }

  virtual void redraw() { 
    plate::redraw();  
    int val = mvv_read(reg);
    update(val);
  }

  void test_new() { // called from other buttons and scrollbars 
    int val = mvv_read(reg); 
    if (oldval != val) {
      plate::redraw(); 
      set_color(white); update(val); set_color(black);
    }
  }
};

#define nregs 72
register_window *regw[nregs];

// update all registers (not only changed ones)
void update_register_window() {
  int reg;
  for (reg=0; reg < nregs; reg++) regw[reg]->test_new();
}

// callback fn : reset all register_windows to black (only display)
void reg_redraw() {
 int reg;
   for (reg=0; reg < nregs; reg++) regw[reg]->redraw();
}

// abgeleitet von edit_window : kein Initstring, enter ueberdefiniert : 
// erwartet 2 oder 3 ints als Input : reg(hex) arg1(dez) [arg2]
// falls arg1 > 0xff das high byte als arg2
class reg_edit : public edit_window {
public: reg_edit(window &parent, int w,int h, int x, int y) : 
  edit_window(parent,"",w,h,x,y) {}
  virtual void enter() { 
    int reg, arg1, arg2 = 0,narg;
    narg = sscanf(value,"%x%d%d",&reg,&arg1,&arg2);
    if ( narg < 2) format_error(); 
    else { 
      printf("setting reg[%x] = %d",reg,arg1);
      mvv_write(reg,arg1); 
      if (arg1 > 0xff) arg2 = arg1 >> 8; 
      if ((arg2 > 0) || (narg > 2)) {
	printf(" reg[%x] = %d",reg+1,arg2);
	mvv_write(reg+1,arg2); // write high byte 
      } 
      printf("\n");
      update_register_window();
    } 
  } 
};

// an popup for display and modification of all MVV registers
class register_popup : public main_window { 
public: 
  register_popup(char *Name) : main_window(Name,320,410) {
    int reg;
    int xp = 5, y0 = 5, yp = y0; 
    for (reg = 0; reg < nregs; reg++) { 
      // str muss dynamisch angelegt sein sein !
      char *str = new char[4]; sprintf(str,"%2x",reg);
      new text_win(*this,str,20,20,xp,yp,1);
      regw[reg] = new register_window(*this,reg,35,20,xp+22,yp);
      yp += 25; if (yp+20 > height) { yp = y0; xp += 60; }
    }
    new callback_button(*this,"reset",reg_redraw,60,20,xp,yp);
    yp += 25;
    new text_win(*this,"edit regs",60,20,xp,yp); yp+=25;
    new reg_edit(*this,60,20,xp,yp);  yp += 25;
    new unmap_button(*this,"close",60,20,xp,yp);
  }
};

struct but_cb pal_list[] = 
   { {"set standard palette", std_coltab555 }, 
     {"grey scale palette", grey_coltab555 }, 
     {"set to last captured", set_auto_pal555 } };

// interface functions for menu buttons
void show_captures_1() {
  show_capture_dir("disp-cap"); // the 1. directory with the captures
}
void show_captures_2() {
  show_capture_dir("cis-cap"); // the 2. directory with the captures
}

struct but_cb file_list[] = 
   { { "save image.pix", save_pix },
     { "load image.pix", load_pix_interactive },
     { "save capture", save_capture },
     { "load capture", load_capture_interactive }, 
     { "save palette", save_palette },
     { "load palette", load_palette_interactive },
     { "save ppm", save_ppm },
     { "all caps 1", show_captures_1 }, // show compressed captures
     { "all caps 2", show_captures_2 }
   };

Bool *poll_ptr; // a publicly available pointer to polling_mode

// specialized main_window for display PMS captures, 
// contains menue_bar, view_window, info_window
// handle resizes events to set resolution
// possibly actions from radio_menu
class PMS_window : public main_window {
int xp,yp;
public:
  menu_bar *menub;  
  info_window *infw;
  PMS_window(char *Name, int xp, int yp, Bool poll) : 
  main_window(Name,biWidth,biHeight+40,1,xp,yp), xp(xp), yp(yp) { 
    polling_mode = poll;
    poll_ptr = &polling_mode;
    menub = new menu_bar(*this,width,20,0,0,30); // top
    infw = new info_window(*this,width,20,0,height-20); // bottom
    grab_wi = new view_window(*this,0,20,infw);
  }
  // set resolution, move && resize all children
  virtual void resize(int w, int h) {  
    if ((w != width) || (h != height)) {
      width = w; height = h;     
      int we = w & ~1, hh = h - 40;
      biWidth = we;  // even 
      biHeight = hh ;  // - display-line - menu_bar
      create_buffers_resolution();
      grab_wi->resize(biWidth,biHeight); 
      menub->resize(w,20);
      infw->resize(w,20); 
      XMoveWindow(display,infw->Win,0,height-20); 
    }
  }
  virtual void polling_handler() { 
    show_capt(); 
  }

  // from radio menu called :
  virtual void action(char * menu, char *val) { }
  
};

main(int argc, char *argv[]) { 
  biWidth = 340; biHeight = 255;
  mvv_init();
  all_defaults();
  get_visual(); // init vars about visual

  Bool play = (argc == 1);
  // if an arg is given it should be the name of cap-file
  // else polling mode is set
  PMS_window *pw = new PMS_window(argv[0], 200,200,play);
 
  if (! play) { 
    FILE *fload; 
    fload = fopen(argv[1],"r");
    load_capture_file(fload,argv[1]); fclose(fload);
  }

  main_window *opt_popup = new option_popup("options");  
  main_window *reg_popup = new register_popup("registers");
  menu_bar *menub = pw->menub;
  new callback_button(*menub, "grab", show_capt);
  new toggle_button(*menub, "life", poll_ptr);
  new popup_button(*menub, opt_popup, "MVV set");
  new popup_button(*menub, reg_popup, "MVV regs");
  if (! True_Color) {
    make_pulldown_menu(*menub,"set pal",3, pal_list);
    new callback_button(*menub, "eval", make_eval_popup);
  }
  int nfl = sizeof(file_list)/sizeof(struct but_cb);
  make_pulldown_menu(*menub,"file", nfl, file_list);
  new quit_button(*menub);

  set_resolution(); 

  max_cols = 0; // number of allocated color cells
  long unsigned plane_mask;
  if (! True_Color) {
    while // allocate all available color cells to array pixtab[] !!
      (XAllocColorCells(display,def_cmap,True,&plane_mask,0,
			&pixtab[max_cols],1)) max_cols++; 
    printf("allocated %d color cells\n",max_cols);
    create_std_coltab555(); 
  }
  pw->main_loop();
  if (act_image) delete act_image; // free SHM descriptors !!
}

