extern Bool True_Color; // if T : no coltab mapping !
extern int image_depth; // 8 (PseudoColor) 16 (TrueColor) or 32

void get_visual(); // get these values

void save_image(XImage *ximage, char *fina, int ncols,unsigned long *pixtab);
XImage* load_image(char *fina, int &ncols, unsigned long *pixtab);

void load_pix_file(FILE *fload);
void load_capture_file(FILE *fload, char *);
void save_pix();
void load_pix_interactive();
void save_capture();
void save_ppm();
void load_capture_interactive();
void save_palette();
void load_palette_interactive();
void show_capture_dir(char *dirname);

#ifdef MIT_SHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
extern "C" int XShmQueryExtension(Display*);
#endif

// class that holds an image buffer (short) and a Ximage struct
// if direct_map is True : grab directly into ximage buffer
// if shm is also True : try using SHM extension for speedup
class mapped_image {
  Bool direct_map, use_shm;
  int nn;
#ifdef MIT_SHM
  XShmSegmentInfo shminfo;
#endif
public: 
  unsigned short *buf_16; 
  XImage *ximage;

  mapped_image(int w, int h, Bool direct_map, Bool shm = True);
  ~mapped_image();
  void map_buffer(); // map cap_buf into ximage
  void PutImage(Drawable Win, int x, int y, int ww, int wh);

};

