
#ifndef SMAFCTABLE_H
#define SMAFCTABLE_H

typedef  struct _SMAFCTableEntry
{
	char	channelName[80];
	float	frequency;
}SMAFCTableEntry;

typedef struct _SMAFCTable
{
	int					numEntries;
	char				tableName[1024];
	float				_channelRange;
	SMAFCTableEntry		*_tableEntries;
} SMAFCTable;

short  _smAFC_AllocEntryList(SMAFCTable *table, int entries);
short  smAFC_InitTableFromFile(SMAFCTable *table, const char* filename);
char*  smAFC_TableName(SMAFCTable *table);
int    smAFC_NextValForFreq(SMAFCTable *table, int aFreq);
int    smAFC_FreqForVal(SMAFCTable *table, int aVal);
char*  smAFC_ChannelNameForVal(SMAFCTable *table, int aVal);
char*  smAFC_ChannelNameForFreq(SMAFCTable *table, int aFreq);
unsigned int smAFC_Count(SMAFCTable *table);

#endif
