/* ================================================================*\

	fgtopbm.c -- a program that dumps a video frame from the
		WinVision frame grabber to standard output in PBM
		greyscale format. It lets the device driver perform
		the aspect ratio expansion.

	(C) Carlos Puchol, 1993
	    cpg@cs.utexas.edu
	    P.O. Box 7817
	    Austin, TX 78713-7817

	This program may be distributed/modified/copied under the terms
	of the GNU GENERAL PUBLIC LICENSE. It comes as is, with no
	guarantees.

\* ================================================================*/

#include <stdio.h>
#include <fcntl.h>

#define FG_EXPANSION_SET	0x0008

typedef	unsigned char byte;

#define TOTY		242
#define TOTX		310

typedef struct {
	int	HSize;
	int	VSize;
	int	HSkip;
	int	VSkip;
	unsigned char	pixels[TOTY][TOTX];
	} t_image;

t_image	image;

int	fd;

void main(void)
{
	int	i, j, res, read();
	long	val;

	if ((fd=open("/dev/fgrabber", O_RDWR)) < 0 ) {
		perror("Could not open frame grabber, giving up");
		exit(-1);
	}

	res = ioctl(fd, FG_EXPANSION_SET, 1);
	if (res < 0) {
		perror ("Trying the FG_EXPANSION_SET IOCTL to the frame grabber");
		exit(-1);
	}

	image.HSize=TOTX;
	image.VSize=TOTY;
	image.HSkip=0;
	image.VSkip=0;

	res = read(fd, &image, sizeof(image));

	if (res < 0) {
		perror ("Reading from frame grabber");
		exit(-1);
	}

	printf("P2\n");
	printf("# CREATOR Carlos Puchol, cpg@cs.utexas.edu\n");
	printf("%d %d\n", TOTX, TOTY);
	printf("255\n");

	val=0;
	for (j=0; j < TOTY; j++) {
		for (i=0; i < TOTX; i++ ) {
			printf("%3d ", image.pixels[j][i]);
			if (!(++val % 15 )) {
				printf("\n");
		   }
		}
        }
}
