/* Zgv v2.3 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993, 1994 Russell Marks. See README for license details.
 *
 * magic.c - Determines GIF/JPG/PNM file.
 */

#include <stdio.h>
#include <string.h>
#include "magic.h"


int magic_ident(filename)
char *filename;
{
FILE *in;
unsigned char buf[3];

if((in=fopen(filename,"rb"))==NULL)
  return(_IS_BAD);

buf[0]=buf[1]=buf[2]=0;
fread(buf,1,3,in);
fclose(in);

/* We use the following rules:
 * P?M files must have 'P', then a digit; '1'<=digit<='6'.
 * GIF files must have "GIF"
 * JPEG files must have first byte=0xff, second byte=0xd8 (M_SOI)
 */

/* PBM/PGM/PPM */
if(buf[0]=='P' && buf[1]>='1' && buf[1]<='6')
  return(_IS_PNM);

/* GIF */
if(strncmp(buf,"GIF",3)==0)
  return(_IS_GIF);

/* JPEG */
if(buf[0]==0xff && buf[1]==0xd8)
  return(_IS_JPEG);

/* if no valid header */
return(_IS_BAD);
}
