/*
 * names.h: Header for names.c
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef _NAMES_H_
#define _NAMES_H_

#include "window.h"

#define MODE_PRIVATE 1
#define MODE_LIMIT 2
#define MODE_TOPIC 4
#define MODE_ANONYMOUS 8
#define MODE_INVITE 16
#define MODE_MSGS 32
#define MODE_SECRET 64
#define MODE_MODERATED 128

/* ChannelList: structure for the list of channels you are current on */
typedef	struct	channel_stru
{
	struct	channel_stru	*next;	/* pointer to next channel entry */
	char	*channel;		/* channel name */
	int	server;			/* server index for this channel */
	unsigned char	mode;		/* Current mode settings for channel */
	int	limit;			/* max users for the channel */
	char	chop;			/* true if you are chop */
	Window	*window;		/* the window that the channel is "on" */
	NickList	*nicks;		/* pointer to list of nicks on channel */
}	ChannelList;

extern	int	is_channel_mode();
extern	ChannelList	*lookup_channel();
extern	char	*get_channel_mode();
extern	void	add_channel();
extern	void	add_to_channel();
extern	void	remove_channel();
extern	void	remove_from_channel();
extern	int	is_on_channel();
extern	void	list_channels();
extern	void	reconnect_all_channels();
extern	void	switch_channels();
extern	char	*what_channel();
extern	char	*walk_channels();
extern	char	*real_channel();
extern	char	*old_current_channel();
extern	void	rename_nick();
extern	void	update_channel_mode();
extern	void	set_channel_window();

#endif /* _NAMES_H_ */
