#include <stdio.h>
#include <sys/types.h>
#include "conf.h"
#include "readline.h"
#include "nntplink.h"

extern int Input_from;
#ifdef XREPLIC
extern int Xreplic;
#endif

Boolean
  parse_entry(entry)
char *entry;
{
    char *tentry, *tsysname;
    char *beg_mesgid, *end_mesgid;
#ifndef LOOKUP_ARTICLE
    char *beg_filename, *end_filename;
#endif
#ifdef BNEWS
    char *sentto = "sent to";
#endif

    if (Batchfile.use || (Input_from & FLG_STDIN)) {

	Article.filename = entry;

#ifdef BNEWS
	for (; *entry != '\0' && *entry != '\t'; entry++)
	  ;
#else
	for (; *entry != '\0' && *entry != ' '; entry++)
	  ;
#endif

	if (*entry != '\0') {

	    *entry++ = '\0';
	    Article.mesgid = entry;


#ifdef XREPLIC
	    if (!Xreplic) {
#endif

		for (; *entry != '\0' && *entry != ' ' && *entry != '\t';
		     entry++)
		  ;

		if (Article.mesgid[0] != '<' ||
		    *(entry-1) != '>')
		    return FALSE;

		if (*entry != '\0') {
		    *entry++ = '\0';
		    Article.count = atoi(entry);
		}
#ifdef XREPLIC
	    }
#endif
	}

	if (Article.filename[0] == '/' && Article.filename[1] == '\0')
	  Article.filename = NULL;

    } else {

	for (; *entry != '\0' && *entry != '<'; entry++)
	  ;

	if (*entry == '\0')
	  return FALSE;

#ifndef BNEWS
	if (*(entry - 2) == '-')
	  return FALSE;
#endif

	beg_mesgid = entry;

	for (; *entry != '\0' && *entry != '>'; entry++)
	  ;

	if (*entry == '\0')
	  return FALSE;

	if (*(end_mesgid = ++entry) == '\0')
	  return FALSE;

#ifndef LOOKUP_ARTICLE
	if ((*(++entry) != '(') || (*(++entry) == '\0'))
	  return FALSE;

	beg_filename = entry;

	for (; *entry != '\0' && *entry != ')'; entry++)
	  ;

	if (*entry == '\0')
	  return FALSE;

	end_filename = entry;

	if (*++entry == '\0')
	  return FALSE;

#endif /* !LOOKUP_ARTICLE */

#ifdef BNEWS
	if (*++entry == '\0')
	  return FALSE;

	for (; *sentto != '\0' && *sentto == *entry; entry++, sentto++)
	  ;

	if (*sentto != '\0')
	  return FALSE;

#endif /* BNEWS */

	while (*entry != '\0' && *++entry != '\0') {

	    for (tentry = entry, tsysname = Host.sysname;
		 *tsysname != '\0' && *tentry == *tsysname;
		 tentry++, tsysname++)
	      ;

#ifdef BNEWS
	    if ((*tsysname == '\0') &&
		((*tentry == ',') || (*tentry == '\0'))) {
#else
	    if ((*tsysname == '\0') &&
		((*tentry == ' ') || (*tentry == '\0'))) {
#endif
#ifndef LOOKUP_ARTICLE
		Article.filename = beg_filename;
		*end_filename = '\0';
#endif
		Article.mesgid = beg_mesgid;
		*end_mesgid = '\0';
		return TRUE;
	    }

	    for (; *entry != '\0' && *entry != ' '; entry++)
	      ;
	}
	return FALSE;
    }
    return TRUE;
}
