#include <errno.h>
#include "conf.h"
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#include <sys/time.h>
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

extern Boolean Abort_signaled;
extern int Close_after;
extern long Failure_naptime;
extern int Log_after;
extern Boolean One_shot;
extern Boolean Open_art_first;
extern Boolean Reset_signaled;
extern long Success_time;

extern void abort_nntplink();
extern void close_article();
extern Boolean get_next_art();
extern void close_connection();
extern void log();
extern void log_stats();
extern Boolean open_article();
extern Boolean open_connection();
extern char *read_reply();
extern Boolean send_connection();
extern char *send_ihave_msg();
extern void update_batchfile();

Boolean
  send_news()
{
    static char *fname = "send_news: ";
    Boolean failure = FALSE;
    int code;
    char *reply;

    while(!Abort_signaled &&
	  !Reset_signaled &&
	  !failure &&
	  get_next_art()) {

	if (Open_art_first && !open_article())
	  close_article();
	else {
	    if (!Host.connected)
	      if (!open_connection(Host.name, Host.transport))
		return FALSE;

	    reply = send_ihave_msg(&code);
	    switch(code) {
	      case CONT_XFER:
		if (!send_connection(Article.fbp)) {
		    log(LOG_NOTICE, fname, "%s%s: xfer %s: %s\n", Host.name,
			Article.filename, errmsg(errno));
		    failure = TRUE;
		} else {
		    if ((reply = read_reply(&code)) != NULL) {
			if (Article.err != NULL)
			  free(Article.err);
			Article.err = strsave(reply);

		    }
		    if (code == FAIL)
		      close_connection(!SEND_QUIT_MSG);
		    else if ((code != OK_XFERED) && (code != ERR_XFERRJCT)) {
			Article.count++;
			failure = TRUE;
		    }
		}
		break;

	      case ERR_NOFILE:
		(void) read_reply(&code);
		if (code == FAIL)
		  close_connection(!SEND_QUIT_MSG);
		else if ((code != OK_XFERED) && (code != ERR_XFERRJCT) &&
			 (code != ERR_XFERFAIL))
		  log(LOG_NOTICE, fname, "%s%s: bad reply: %s\n",
		      Host.name, errmsg(errno));
		break;

	      case ERR_UNKNOWN:
	      case ERR_NOFILE_CONT:
	      case ERR_NOMSGID:
	      case ERR_GOTIT:
		break;

	      case ERR_GOODBYE:
		failure = TRUE;
		break;

	      case ERR_COMMAND:
	      case FAIL:
		failure = TRUE;
		break;

	      default:
		log(LOG_NOTICE, fname,
		    "%s%s: sent IHAVE %s, received: %s\n",
		    Host.name, Article.mesgid, reply);
		failure = TRUE;
	    }

	    if (failure) {
		Stats.failed++;
		close_connection(!SEND_QUIT_MSG);
		break;
	    } else {
		close_article();
		Failure_naptime = NAPTIME;
		Success_time = time(NULL);
	    }
	}

	if ((Stats.since_close >= Close_after) && Host.connected)
	  close_connection(SEND_QUIT_MSG);

	if (Stats.offered >= Log_after)
	  log_stats();
    }

    if (Abort_signaled)
      abort_nntplink();

    if (Reset_signaled)
      update_batchfile();

    return !failure;
}
