#include "conf.h"
#include <fcntl.h>
#ifdef FAKESYSLOG
#include "fsyslog.h"
#else
#include <syslog.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include "readline.h"
#include "nntplink.h"
#include "nntp.h"
#include "strfuns.h"

#ifdef AUTH

extern char *converse();
extern void fail();
extern void log();

void
  xmitauth(host)
char *host;
{
    static char *fname = "xmitauth: ";
    char *remote, *user, *pass;
    char *line, *reply;
    int resp;
    int sys_fd;
    FileBuf *sys_fbp;


    if ((sys_fd = open(PASSFILE, O_RDONLY)) == FAIL)
      fail(fname, "%s%s: %s not found", Host.name, PASSFILE);

    sys_fbp = fb_fdopen(sys_fd);

    while((line = fb_readline(sys_fbp, NULL)) != NULL)
      if (*line != '#') {

	  remote = line;

	  if ((line = strchr(remote, ' ')) == NULL)
	    log(LOG_NOTICE, fname, "%s%s: malformed entry in nntp.sys\n",
		Host.name);
	  else {
	      *line++ = '\0';
	      user = line;
	      if ((line = strchr(user, ' ')) == NULL)
		log(LOG_NOTICE, fname, "%s%s: malformed entry in nntp.sys\n",
		    Host.name);
	      else {
		  *line++ = '\0';
		  pass = line;
		  if (strcasecmp(remote, host) == MATCH)
		    break;
	      }
	  }
      }

    if (fb_error(sys_fbp))
      log(LOG_WARNING, fname, "%s%s: error reading %s: %s\n",
	  Host.name, PASSFILE, errmsg(errno));

    if (line == NULL)
      fail(fname, "%s%s: host %s authinfo not in nntp.sys\n", Host.name,
	   host);

    line = str2save("authinfo user ", user);
    reply = converse(line, &resp);
    FREE(line);

    if (resp != NEED_AUTHDATA)
      if (resp == FAIL)
	fail(fname,
	     "%s%s: sent authinfo user, exiting due to bad response\n",
	     Host.name);
      else
	fail(fname,
	     "%s%s: sent authinfo user, exiting due to bad response: %s\n",
	     Host.name, reply);

    line = str2save("authinfo pass ", pass);
    reply = converse(line, &resp);
    FREE(line);

    if (resp != OK_AUTH)
      if (resp == FAIL)
	fail(fname,
	     "%s%s: sent authinfo pass, exiting due to bad response\n",
	     Host.name);
      else
	fail(fname,
	     "%s%s: sent authinfo pass, exiting due to bad response: %s\n",
	     Host.name, reply);

    CLOSE(sys_fd);
    fb_close(sys_fbp);
    return;
}
#endif /* AUTH */

