/* Catch and send signals for Linux systems.
   Copyright 1994 Tristan Gingold
		  Written April 1994 by Tristan Gingold

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License 
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 The author may be reached (Email) at the address gingold@amoco.saclay.cea.fr,
 or (US/French mail) as Tristan Gingold 
   			  8 rue Parmentier
   			  F91120 PALAISEAU
   			  FRANCE 
*/
#include "checker.h"
#include "errlist.h"

/* This is computer, CPU, OS and perhaps OS-version dependant ! */

struct sigcontext_struct {
	unsigned short gs, __gsh;
	unsigned short fs, __fsh;
	unsigned short es, __esh;
	unsigned short ds, __dsh;
	unsigned long edi;
	unsigned long esi;
	unsigned long ebp;
	unsigned long esp;
	unsigned long ebx;
	unsigned long edx;
	unsigned long ecx;
	unsigned long eax;
	unsigned long trapno;
	unsigned long err;
	unsigned long eip;
	unsigned short cs, __csh;
	unsigned long eflags;
	unsigned long esp_at_signal;
	unsigned short ss, __ssh;
	unsigned long i387;
	unsigned int oldmask;
	unsigned long cr2;
};

struct sigtosend {
	struct sigtosend *next;	/* link */
	unsigned int nsignal;
	unsigned int mask;
	void *func;
	struct sigcontext_struct context;
};

void _sig_go_on(void *);

struct sigtosend *sighead;
int chkr_sig_catched = 0;

void _sig_save(unsigned int *args, void *func, unsigned int mask)
{
 struct sigtosend *tosend;
 tosend = sys_malloc(sizeof(struct sigtosend));
 if (tosend == 0)
   {
     chkr_errno = E_OUT_OF_SMEM;
     chkr_perror();
     chkr_abort();
   }
 /* fill the fields */
 tosend->next = 0;
 tosend->nsignal = args[0];	/* nsignal */
 tosend->mask = mask;
 tosend->func = func;
 memcpy(&tosend->context, &args[1], sizeof(struct sigcontext_struct));
 /* add to the list */
 if (sighead == 0)
   sighead = tosend;
 else
   {
     /* Follow the links */
     struct sigtosend *f = sighead;
     while (f->next)
       {
         f = f->next;
       }
     f->next = tosend;
     /* not supported yet */
     chkr_errno = E_NOT_RECURS;
     chkr_perror();
     chkr_abort();
   }
#if 0
 /* Just print a message */
 chkr_header("I received a signal (%d)\n", args[0]);
#endif
 /* Notify a signal has been catched */
 chkr_sig_catched++;
 /* go on */
 _sig_go_on(&args[1]);
}

struct reg
{
  unsigned int eax;
  unsigned int ecx;
  unsigned int edx;
  unsigned int ebx;
  unsigned int esp;
  unsigned int ebp;
  unsigned int esi;
  unsigned int edi;
  unsigned int eip;
  unsigned char flags;
};

void sigreturn(struct sigcontext_struct*);

void _sig_send(struct reg *reg)
{
 struct sigtosend *tosend;
 struct sigcontext_struct sigcontext;
 void (*func1)(int, struct sigcontext_struct);
 tosend = sighead;
 sighead = tosend->next;
 func1 = tosend->func;
 sigcontext = tosend->context;
 /* set sigcontext */
 sigcontext.eax = reg->eax;
 sigcontext.ecx = reg->ecx;
 sigcontext.edx = reg->edx;
 sigcontext.ebx = reg->ebx;
 sigcontext.esp = reg->esp;
 sigcontext.ebp = reg->ebp;
 sigcontext.esi = reg->esi;
 sigcontext.edi = reg->edi;
 sigcontext.eip = reg->eip;
 sigcontext.eflags = reg->flags;
 /* Don't forget this! */
 chkr_sig_catched--;
 /* set block mask */
 sigprocmask(SIG_SETMASK, &(tosend->mask), 0);
 /* And call */
 (*func1)(tosend->nsignal, sigcontext);
 sigreturn(&sigcontext);
#if 0
 /* We emulate sigreturn... */
 sigprocmask(SIG_SETMASK, &(tosend->context.oldmask), 0);
 _sig_go_on(&sigcontext);
#endif
}
  