/*
 * wbset.c
 * 
 * Setup loader for the WaveBlaster board using the Linux Sound Driver.
 * 
 * Copyright by Hannu Savolainen 1993
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

/*
 * You have to change the CBK_PATH
 */
#ifndef CBK_PATH
#define CBK_PATH	"/C/waveblst/wbpanel/"
#endif

#define BUFLEN 1024
int fd;
int mididev;

void
dump(int cbkfd)
{
  int i, tmp, n, p;
  unsigned char buf[BUFLEN], obuf[4 * BUFLEN] =
  {0};

  while ((n = read (cbkfd, buf, BUFLEN)) > 0)
    {
      p = 0;

      for (i = 0; i < n; i++)
	{
	  obuf[p + 0] = SEQ_MIDIPUTC;
	  obuf[p + 1] = buf[i];
	  obuf[p + 2] = mididev;
	  obuf[p + 3] = 0;
	  p += 4;
	}

      if (write (fd, obuf, p) != p)
      {
      	perror("/dev/sequencer");
      	exit(-1);
      }

    }
}

main (int argc, char *argv[])
{
  int i, tmp, n, p;
  struct midi_info info;

  int cbkfd;	/* Sysex file */
  char cbk_name[1024];

  if (argc !=3)
  {
  	fprintf(stderr, "usage: %s <setupname>.cgs <bankname>.cbk\n", argv[0]);
  	exit(-1);
  }

  if ((fd = open ("/dev/sequencer", O_WRONLY, 0)) == -1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

/*
 * First locate the SB16 midi interface. The WaveBlaster is sitting there.
 */

  if (ioctl(fd, SNDCTL_SEQ_NRMIDIS, &n)==-1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

  mididev = -1;

  for (i=0;i<n && mididev == -1;i++)
  {
    info.device = i;
    if (ioctl(fd, SNDCTL_MIDI_INFO, &info)==-1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

    if (info.dev_type == SNDCARD_SB16MIDI) mididev=i;
  }

  if (mididev == -1)
  {
  	fprintf(stderr, "%s: SB16 Midi device not found\n");
  	exit(-1);
  }

  sprintf(cbk_name, CBK_PATH "%s.cgs", argv[2]);

  if ((cbkfd = open (cbk_name, O_RDONLY, 0)) == -1)
    {
      perror (cbk_name);
      exit (-1);
    }

   dump(cbkfd);
   close(cbkfd);

  sprintf(cbk_name, CBK_PATH "%s.cbk", argv[2]);

  if ((cbkfd = open (cbk_name, O_RDONLY, 0)) == -1)
    {
      perror (cbk_name);
      exit (-1);
    }

   dump(cbkfd);
   close(cbkfd);

   exit(0);
}
