#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/soundcard.h>

#define BUFLEN 1024
SEQ_DEFINEBUF(4*BUFLEN);

int seqfd;
int mididev=3;
int tempo=60;
int timebase=192;
int delay=10;

void
seqbuf_dump ()
{
  if (_seqbufptr)
    if (write (seqfd, _seqbuf, _seqbufptr) == -1)
      {
	perror ("write /dev/sequencer");
	exit (-1);
      }
  _seqbufptr = 0;
}

main (int argc, char *argv[])
{
  int i, tmp, n, p;
  struct midi_info info;

  int cbkfd;	/* Sysex file */
  char cbk_name[1024];

  if (argc>1) delay=atoi(argv[1]);
  if (argc>2) tempo=atoi(argv[2]);
  if (argc>3) timebase=atoi(argv[3]);

  if ((seqfd = open ("/dev/sequencer2", O_RDWR, 0)) == -1)
    {
      perror ("/dev/sequencer");
      exit (-1);
    }

	tmp=timebase;
	if (ioctl(seqfd, SNDCTL_TMR_TIMEBASE, &tmp)==-1)
	{
		perror("Set timebase");
		exit(-1);
	}

	tmp = tempo;
	if (ioctl(seqfd, SNDCTL_TMR_TEMPO, &tmp)==-1)
	{
		perror("Set tempo");
		exit(-1);
	}

	SEQ_START_TIMER();
	while (1)
	{
		SEQ_START_NOTE(mididev, 9, 60, 64);
		SEQ_DELTA_TIME(delay);
		SEQ_STOP_NOTE(mididev, 9, 60, 64);
		SEQ_DELTA_TIME(delay);
	}

	exit(0);

}
