#include "cs.h"				/*	       SFHEADER.C	*/
#include "soundio.h"
#include <stdio.h>

extern OPARMS O;

#ifdef SFIRCAM

#include "sfheader.h"
static  char    *incodbeg,  *incodend;   /* re-defined by each readheader */
static  char    *outcodbeg, *outcodend;  /* defined during writeheader */

typedef struct {                  /* header for each sfcode block */
	short	type;
	short	blksiz;
} CODE_HDR;

static short codblksiz[] = {   sizeof(CODE_HDR),
			       sizeof(CODE_HDR) + sizeof(SFMAXAMP),
			       sizeof(CODE_HDR) + sizeof(SFAUDIOENCOD),
			       sizeof(CODE_HDR) + sizeof(SFPVDATA),
			       sizeof(CODE_HDR) + sizeof(SFCOMMENT)  };

static void putendcode(cp)
 char *cp;
{
	register CODE_HDR *cdhp = (CODE_HDR *)cp;
	cdhp->type = SF_END;
	cdhp->blksiz = sizeof(CODE_HDR);  /* header, no body */
}

/* These next rtn ptr to beg of struct reqd (not the CODE_HDR preceding it).
   SR, NCHNLS, magic number, bytes/chan, are NOT coded via these routines. */

char *findsfcode(ctype)      /* locate start of sfcode in current in_header */
 int  ctype;                 /*    incodbeg,incodend prev set by readheader */
{                            /*      used here,  & by ugens8.c (PVOC)       */
	register char     *cp;
	register CODE_HDR *cdhp;

	if (ctype <= 0 || ctype > SF_CODMAX)
	    die("illegal sfcode type");
	for (cp = incodbeg; cp < incodend;) { /* starting from beg codespace */
	    cdhp = (CODE_HDR *)cp;
	    if (cdhp->type == ctype)             /* if find required code */
	        return(cp + sizeof(CODE_HDR));   /*   return ptr to data  */
	    if (cdhp->type == SF_END)            /* can't find -- exit    */
	        break;
	    if (cdhp->blksiz <= 0                /* if false-sized struct or */
	     || (cp += cdhp->blksiz) < incodbeg){/* wrap-around from bad hdr */
	        fprintf(stderr,"sfheader codes corrupted\n");    /* complain */
	        break;
	    }
	}
	return(NULL);                        /* no-find: return NULL pointer */
}

char *creatsfcode(ctype)    /* add a new sfcode struct to current out_header */
 int  ctype;                /*   outcodbeg,outcodend prev set by writeheader */
{
	register char     *cp;
	register CODE_HDR *cdhp;

	if (ctype <= 0 || ctype > SF_CODMAX)
	    die("illegal sfcode type");
	for (cp=outcodbeg; cp<outcodend; ) { /* starting from beg codespace  */
	    cdhp = (CODE_HDR *)cp;
	    if (cdhp->type == SF_END) {             /* if find end code      */
	        cdhp->type = ctype;                 /*   redo as newtyp hdr  */
		cdhp->blksiz = codblksiz[ctype];
		putendcode(cp+cdhp->blksiz);        /*   reconstruct endcode */
	        return(cp+sizeof(CODE_HDR));        /*   & rtn newtyp datptr */
	    }
	    if (cdhp->blksiz <= 0                /* if false-sized struct or */
	     ||(cp += cdhp->blksiz) < outcodbeg){/* wrap-around from bad hdr */
	        fprintf(stderr,"sfheader codes corrupted\n");    /* complain */
	        break;
	    }
	}
	return(NULL);                       /* bad ptrs: return NULL pointer */
}

#endif

#ifdef NeXT
#include <sound/soundstruct.h>
#endif /* NeXT */

#ifdef SFSUN41
#define INFOMAX   100    /* blksiz for SUN info data */
static  char    *ininfop, *outinfop;   /* blks of INFOMAX bytes for SUN info */
#endif

static	char	*inhdrblk, *outhdrblk;  /* (whichever) soundfile header blks */
static  HEADATA HeadData;               /* datablk for general return        */
extern  void    aiffReadHeader(), wavReadHeader();
extern  int     is_aiff_form(), is_wav_form();
extern  char    *getstrformat();

HEADATA *readheader(ifd,sfname,p) /* read soundfile hdr, fill HEADATA struct */
 int ifd;                         /*   called by sfopenin() and sndinset()   */
 char *sfname;                    /* NULL => no header, nothing to preserve  */
 SOUNDIN *p;
{
        long    headfirstlong;
	register HEADATA *hdp = &HeadData;
#ifndef THINK_C
static struct 	stat statbuf;
#endif
							/* read the 1st long */
	sreadin(ifd, (char *)&headfirstlong, sizeof(long), p);
	if (is_aiff_form(headfirstlong)) {             /* if AIFF form       */
	    aiffReadHeader(ifd,sfname,hdp,headfirstlong,p);  /*   read hdr.. */
	    return(hdp);                               /*   and report back  */
	}
	if (is_wav_form(headfirstlong)) {              /* if WAV form        */
	    wavReadHeader(ifd,sfname,hdp,headfirstlong,p);   /*   read hdr.. */
	    return(hdp);                               /*   and report back  */
	}
	hdp->filetyp = 0;                     /* else neither AIFF nor WAV   */
#ifndef THINK_C
	fstat(ifd, &statbuf);
	hdp->audsize = statbuf.st_size;       /* audsize including header */
#endif
#ifdef SFIRCAM
	if (headfirstlong == SF_MAGIC) {      /* if IRCAM header, read rem */
	    register SFHEADER *sfh;
	    SFAUDIOENCOD *aep;
	    int  n;

	    if (inhdrblk == NULL)
	        inhdrblk = mmalloc((long)sizeof(SFHEADER));
	    sfh = (SFHEADER *) inhdrblk;
	    sreadin(ifd, inhdrblk+sizeof(long), sizeof(SFHEADER)-sizeof(long), p);
	    hdp->sr = (long) sfsrate(sfh);
	    hdp->nchnls = sfchans(sfh);        /*   and record the data */
	    hdp->sampsize = sfclass(sfh);
	    incodbeg = &sfcodes(sfh);
	    incodend = (char *)sfh + sizeof(SFHEADER);
	    if ((aep = (SFAUDIOENCOD *) findsfcode(SF_AUDIOENCOD)) != NULL)
	        hdp->format = aep->encoding;
	    else {                       /* if no audioencode info,          */
	        switch (hdp->sampsize) { /* FORMAT BASED ONLY ON BYTE-COUNT! */
		case SF_ULAW:	hdp->format = AE_ULAW;   break;
		case SF_SHORT:	hdp->format = AE_SHORT;  break;
		case SF_FLOAT:	hdp->format = AE_FLOAT;  break;
		default:        hdp->format = O.informat;
		}
		sprintf(errmsg,"audio_in %s format unclear, deducing %s",
			sfname, getstrformat((int)hdp->format));
		warning(errmsg);
	      }
	    hdp->hdrsize = sizeof(SFHEADER);   /* hdrsize (for later seeks)  */
	    hdp->audsize -= sizeof(SFHEADER);
	    hdp->readlong = 0;                 /* now aligned on audio_start */
	}
	else if (BYTREVL(headfirstlong) == SF_MAGIC) {  /* else byte-rev: bad */
	    sprintf(errmsg,"%s is soundfile with bytes in the wrong order",sfname);
	    warning(errmsg);
	    return(NULL);
	}
	else {
	    hdp->hdrsize = 0;                  /* else no header,        */
	    hdp->readlong = 1;                 /*   but we read a long   */
	    hdp->firstlong = headfirstlong;    /*   which had this value */
	}
	return(hdp);                /* SFIRCAM always returns hdp, and data */
#endif
#ifdef NeXT
	if (headfirstlong == SND_MAGIC) {      /* if IRCAM header, read rem */
	    register SNDSoundStruct *sfh;
	    int  n;

	    if (inhdrblk == NULL)
	        inhdrblk = mmalloc((long)sizeof(SNDSoundStruct));
	    sfh = (SNDSoundStruct *) inhdrblk;
	    sreadin(ifd, inhdrblk+sizeof(long), 
		    sizeof(SNDSoundStruct)-sizeof(long), p);
	    hdp->sr = sfh->samplingRate;
	    hdp->nchnls = sfh->channelCount;
	    switch(sfh->dataFormat) {	/* map NeXT formats to ours */
	    case SND_FORMAT_MULAW_8:   hdp->format = AE_ULAW;
		hdp->sampsize = 1;	break;
	    case SND_FORMAT_LINEAR_8:  hdp->format = AE_CHAR;
		hdp->sampsize = 1;	break;
	    case SND_FORMAT_LINEAR_16: hdp->format = AE_SHORT;
		hdp->sampsize = 2;	break;
	    case SND_FORMAT_LINEAR_32: hdp->format = AE_LONG;
		hdp->sampsize = 4;	break;
	    case SND_FORMAT_FLOAT:     hdp->format = AE_FLOAT;
		hdp->sampsize = 4;	break;
		default:        hdp->format = O.informat;
		}
	    hdp->hdrsize = sfh->dataLocation;
	    hdp->audsize -= sfh->dataLocation;
	    if (sfh->dataLocation > sizeof(SNDSoundStruct))  /* skip rem hdr */
	       lseek(ifd, sfh->dataLocation-sizeof(SNDSoundStruct), SEEK_CUR);
	    hdp->readlong = 0;                 /* now aligned on audio_start */
	}
	else if (BYTREVL(headfirstlong) == SND_MAGIC) { /* else byte-rev: bad */
	    sprintf(errmsg,"%s is soundfile with bytes in the wrong order",sfname);
	    warning(errmsg);
	    return(NULL);
	}
	else {
	    hdp->hdrsize = 0;                  /* else no header,        */
	    hdp->readlong = 1;                 /*   but we read a long   */
	    hdp->firstlong = headfirstlong;    /*   which had this value */
	}
	return(hdp);
#endif /* NeXT */
#ifdef SFSUN41
	if (inhdrblk == NULL) {
	    inhdrblk = mmalloc((long)sizeof(Audio_hdr));
	    ininfop = mcalloc((long)INFOMAX);
	}
	if (audio_isaudiofile(sfname) == TRUE) {
	    register Audio_hdr *ahp = (Audio_hdr *) inhdrblk;
	    char *infop = NULL;
	    unsigned ilen;
	    if (audio_read_filehdr(ifd,ahp,ininfop, INFOMAX) != AUDIO_SUCCESS)
		die("error reading audio_filehdr");
	    hdp->sr = ahp->sample_rate;
	    hdp->sampsize = ahp->bytes_per_unit;     /* record the data */
	    hdp->nchnls = ahp->channels;
	    switch (ahp->encoding) {                /* Convert format code */
	    case AUDIO_ENCODING_ALAW:
		    hdp->format = AE_ALAW;   break;
	    case AUDIO_ENCODING_ULAW:
		    hdp->format = AE_ULAW;   break;
	    case AUDIO_ENCODING_LINEAR:
		    switch (ahp->bytes_per_unit) {
		    case 1:	hdp->format = AE_CHAR;  break;
		    case 2:	hdp->format = AE_SHORT;  break;
		    case 4:	hdp->format = AE_LONG;  break;
		    default:    sprintf(errmsg,
				"unexpected audio input length of %d (linear)",
					(int) ahp->bytes_per_unit);
		                die(errmsg);
		    }
		    break;
	    case AUDIO_ENCODING_FLOAT:
		    switch (ahp->bytes_per_unit) {
		    case 4:	hdp->format = AE_FLOAT;  break;
		    default:    sprintf(errmsg,
				 "unexpected audio input length of %d (float)",
					(int) ahp->bytes_per_unit);
		                die(errmsg);
		    }
		    break;
	    default:
		    hdp->format = AE_ULAW;
		    sprintf(errmsg,"audio_in %s format unclear, deducing %s",
			    sfname, getstrformat((int)hdp->format));
		    warning(errmsg);
		    break;
	    }
	    hdp->hdrsize = -1;               /* don't know real headdata size */
	    hdp->audsize -= sizeof(Audio_hdr); /* but audio can't include hdr */
	    hdp->readlong = 0;                 /* now aligned on audio_start  */
	    return(hdp);
	}
	else return(NULL);
#endif
#ifdef THINK_C
	{
	    float   fsr;               /* file sample rate */
	    int     fnch, fbpd;        /* file channels & bytes per datum */
	    FILE    *fp;

	    if (ReadMacHeader(sfname,&fnch,&fsr,&fbpd) == 0) {  /* get rsrc */
	        hdp->sr = fsr;
		hdp->nchnls = fnch;                         /*  record data */
		hdp->sampsize = fbpd;
		hdp->format = (fbpd == 4)?AE_FLOAT: AE_SHORT; /* 2 poss fmts */
		hdp->hdrsize = 0;                     /* no header on file   */
		if ((fp = fopen(sfname, "r")) == NULL)
		    return(NULL);
		hdp->audsize = fp->len;           /* open/close just for len */
		fclose(fp);
		hdp->readlong = 0;                /* aligned to audio_start  */
		return(hdp);
	    }
	    else return(NULL);
	}
#endif
}

void writeheader(ofd,ofname)  /* write an sfheader struct into output stream */
 int  ofd;                    /*        called only by sfopenout()           */
 char *ofname;
{
    if (O.filetyp) {
        if (O.filetyp == TYP_AIFF)
	    aiffWriteHdr(ofd,O.outsampsiz,nchnls,esr);
	else if (O.filetyp == TYP_WAV)
	    wavWriteHdr(ofd,O.outsampsiz,nchnls,esr);
    }
    else {
#ifdef SFIRCAM
        register SFHEADER *sfh;
	int n;
	SFAUDIOENCOD *aep;
	void sndwrterr();
	outhdrblk = mcalloc((long)sizeof(SFHEADER));	/* allocate hdr blk */
	sfh = (SFHEADER *)outhdrblk;
	sfmagic(sfh) = SF_MAGIC;
	sfsrate(sfh) = esr;     			/*  assgn headrvals */
	sfchans(sfh) = nchnls;
	sfclass(sfh) = O.outsampsiz;
	outcodbeg = &sfcodes(sfh);                      /* set sfcode limits */
	outcodend = (char *)sfh + sizeof(SFHEADER);
	putendcode(outcodbeg);          	        /* initial sfendcode */
	if ((aep = (SFAUDIOENCOD *) creatsfcode(SF_AUDIOENCOD)) != NULL) {
	    aep->encoding = O.outformat;                /*  ..add encode blk */
	    aep->grouping = 1;
	}
	if ((n = write(ofd,sfh,sizeof(SFHEADER))) < sizeof(SFHEADER))
	        sndwrterr(n, sizeof(SFHEADER));
#endif
#ifdef NeXT
        register SNDSoundStruct *sfh;
	int n;
	void sndwrterr();
	outhdrblk = mcalloc((long)sizeof(SNDSoundStruct)); /* alloc hdr blk */
	sfh = (SNDSoundStruct *)outhdrblk;
	sfh->magic = SND_MAGIC;
	sfh->samplingRate = esr;     			/*  assgn headrvals */
	sfh->channelCount = nchnls;
	sfh->dataLocation = sizeof(SNDSoundStruct);
	sfh->dataSize = -1;
	/* set formats .. */
	switch(O.outformat)
	    {
	case AE_ULAW:	sfh->dataFormat = SND_FORMAT_MULAW_8;	break;
	case AE_CHAR:	sfh->dataFormat = SND_FORMAT_LINEAR_8;	break;
	case AE_SHORT:	sfh->dataFormat = SND_FORMAT_LINEAR_16;	break;
	case AE_LONG:	sfh->dataFormat = SND_FORMAT_LINEAR_32;	break;
	case AE_FLOAT:	sfh->dataFormat = SND_FORMAT_FLOAT;	break;
	default:	sfh->dataFormat = SND_FORMAT_LINEAR_16;	/* lose.. */
	    }
	if ((n = write(ofd,sfh,sizeof(SNDSoundStruct)))<sizeof(SNDSoundStruct))
	        sndwrterr(n, sizeof(SNDSoundStruct));
#endif /* NeXT */
#ifdef SFSUN41
	register Audio_hdr *hp;
	unsigned encode;               /* chk that requested coding is legal */
	if (!(encode = (O.outformat==AE_ALAW)? AUDIO_ENCODING_ALAW :
	               (O.outformat==AE_ULAW)? AUDIO_ENCODING_ULAW :
	               (O.outformat==AE_CHAR)? AUDIO_ENCODING_LINEAR :
	               (O.outformat==AE_SHORT)? AUDIO_ENCODING_LINEAR :
	               (O.outformat==AE_LONG)? AUDIO_ENCODING_LINEAR :
		       (O.outformat==AE_FLOAT)? AUDIO_ENCODING_FLOAT : 0))
	        die("illegal encode for SFSUN41");
	outhdrblk = mcalloc((long)sizeof(Audio_hdr));	/* allocate hdr blk */
	hp = (Audio_hdr *)outhdrblk;
	hp->sample_rate = (unsigned) esr;           /*  & fill in its values */
	hp->samples_per_unit = 1;
	hp->bytes_per_unit = (unsigned)O.outsampsiz;
	hp->channels = (unsigned) nchnls;
	hp->encoding = encode;
	hp->data_size = AUDIO_UNKNOWN_SIZE;
	if (audio_write_filehdr(ofd, hp, NULL, 0) != AUDIO_SUCCESS)
	        die("couldn't write the outfile header");
#endif
    }
}

void rewriteheader(ofd, datasize) /* write MaxAmps (IRCAM) or datasize (SUN) */
  int      ofd;                   /* to existing hdr; called by sfcloseout() */
  long     datasize;              /*   & optionally by audwrite() under -R   */
{
	int n;

	if (O.filetyp == TYP_AIFF)
	    aiffReWriteHdr(ofd, datasize);
	else if (O.filetyp == TYP_WAV)
	    wavReWriteHdr(ofd, datasize);
	else {
#ifdef SFIRCAM
	    register SFHEADER *sfh;
	    SFMAXAMP *maxp;
	    extern  float    omaxamp[];

	    sfh = (SFHEADER *)outhdrblk; /* update init hdr blk with maxamps */
	    if ((maxp = (SFMAXAMP *) creatsfcode(SF_MAXAMP)) != NULL)
	        for (n = 0; n < SF_MAXCHAN; n++)
		    maxp->value[n] = omaxamp[n];
	    lseek(ofd,0L,0);
	    wheader(ofd,sfh);
#endif
#ifdef NeXT
	    /* attempt to rewrite datasize in initial header */
	    /* datasize should be number of BYTES in SOUND only - not header */
	    long dpos = (unsigned int)&(((SNDSoundStruct *)NULL)->dataSize);
	    /* dpos is the offset of the dataSize field within soundstruct */

	    if (lseek(ofd, dpos, SEEK_SET) == dpos)
		write(ofd, &datasize, sizeof(datasize));
#endif /* NeXT */
#ifdef SFSUN41
	    if ((n = audio_rewrite_filesize(ofd, datasize)) != AUDIO_SUCCESS
		&& n != AUDIO_ERR_NOEFFECT)
	            die("error writing size into sfheader");
#endif
	}
}



